/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Host
implements Serializable,
Comparable<Host> {
    private static final Logger log = Logger.getLogger(Host.class);
    private final Credentials cloudfront = new Credentials();
    private Protocol protocol;
    private String region;
    private Integer port = -1;
    private String hostname;
    private Credentials credentials;
    private String uuid;
    private String nickname;
    private String defaultpath;
    private Path workdir;
    private String encoding;
    private FTPConnectMode connectMode = FTPConnectMode.unknown;
    private TransferType transfer = TransferType.unknown;
    private Local downloadFolder;
    private Local uploadFolder;
    private TimeZone timezone;
    private String comment;
    private String webURL;
    private Date timestamp;
    private Local volume;
    private Boolean readonly;
    private Map<String, String> custom;

    public Host(Protocol protocol) {
        this(protocol, protocol.getDefaultHostname());
    }

    public Host(Protocol protocol, String hostname) {
        this(protocol, hostname, protocol.getDefaultPort());
    }

    public Host(Protocol protocol, String hostname, Credentials credentials) {
        this(protocol, hostname, protocol.getDefaultPort(), credentials);
    }

    public Host(Protocol protocol, String hostname, int port) {
        this(protocol, hostname, port, protocol.getDefaultPath());
    }

    public Host(Protocol protocol, String hostname, int port, String defaultpath) {
        this(protocol, hostname, port, defaultpath, new Credentials());
    }

    public Host(Protocol protocol, String hostname, int port, Credentials credentials) {
        this(protocol, hostname, port, protocol.getDefaultPath(), credentials);
    }

    public Host(Protocol protocol, String hostname, int port, String defaultpath, Credentials credentials) {
        this.protocol = protocol;
        this.hostname = hostname;
        this.port = port;
        this.defaultpath = defaultpath;
        this.credentials = credentials;
    }

    public Host(Host other) {
        this.protocol = other.protocol;
        this.region = other.region;
        this.port = other.port;
        this.hostname = other.hostname;
        this.credentials = new Credentials(other.credentials);
        this.uuid = other.uuid;
        this.nickname = other.nickname;
        this.defaultpath = other.defaultpath;
        this.workdir = other.workdir;
        this.encoding = other.encoding;
        this.connectMode = other.connectMode;
        this.transfer = other.transfer;
        this.downloadFolder = other.downloadFolder;
        this.uploadFolder = other.uploadFolder;
        this.timezone = other.timezone;
        this.comment = other.comment;
        this.webURL = other.webURL;
        this.timestamp = other.timestamp;
        this.volume = other.volume;
        this.readonly = other.readonly;
        this.custom = other.custom;
    }

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(this.protocol.getIdentifier(), "Protocol");
        if (StringUtils.isNotBlank((CharSequence)this.protocol.getProvider()) && !StringUtils.equals((CharSequence)this.protocol.getProvider(), (CharSequence)this.protocol.getIdentifier())) {
            dict.setStringForKey(this.protocol.getProvider(), "Provider");
        }
        if (StringUtils.isNotBlank((CharSequence)this.nickname)) {
            dict.setStringForKey(this.nickname, "Nickname");
        }
        dict.setStringForKey(this.getUuid(), "UUID");
        dict.setStringForKey(this.hostname, "Hostname");
        dict.setStringForKey(String.valueOf(this.getPort()), "Port");
        if (StringUtils.isNotBlank((CharSequence)this.credentials.getUsername())) {
            dict.setStringForKey(this.credentials.getUsername(), "Username");
        }
        if (StringUtils.isNotBlank((CharSequence)this.cloudfront.getUsername())) {
            dict.setStringForKey(this.cloudfront.getUsername(), "CDN Credentials");
        }
        if (StringUtils.isNotBlank((CharSequence)this.defaultpath)) {
            dict.setStringForKey(this.defaultpath, "Path");
        }
        if (this.workdir != null) {
            dict.setObjectForKey(this.workdir, "Workdir Dictionary");
        }
        if (StringUtils.isNotBlank((CharSequence)this.encoding)) {
            dict.setStringForKey(this.encoding, "Encoding");
        }
        if (StringUtils.isNotBlank((CharSequence)this.credentials.getCertificate())) {
            dict.setStringForKey(this.credentials.getCertificate(), "Client Certificate");
        }
        if (null != this.credentials.getIdentity()) {
            dict.setStringForKey(this.credentials.getIdentity().getAbbreviatedPath(), "Private Key File");
            dict.setObjectForKey(this.credentials.getIdentity(), "Private Key File Dictionary");
        }
        if (this.protocol.getType() == Protocol.Type.ftp && this.connectMode != FTPConnectMode.unknown) {
            dict.setStringForKey(this.connectMode.name(), "FTP Connect Mode");
        }
        if (this.transfer != TransferType.unknown) {
            dict.setStringForKey(this.transfer.name(), "Transfer Connection");
        }
        if (null != this.downloadFolder) {
            dict.setStringForKey(this.downloadFolder.getAbbreviatedPath(), "Download Folder");
            dict.setObjectForKey(this.downloadFolder, "Download Folder Dictionary");
        }
        if (null != this.uploadFolder) {
            dict.setObjectForKey(this.uploadFolder, "Upload Folder Dictionary");
        }
        if (null != this.timezone) {
            dict.setStringForKey(this.getTimezone().getID(), "Timezone");
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            dict.setStringForKey(this.comment, "Comment");
        }
        if (null != this.webURL) {
            dict.setStringForKey(this.webURL, "Web URL");
        }
        if (null != this.timestamp) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Access Timestamp");
        }
        if (null != this.volume) {
            dict.setStringForKey(String.valueOf(this.volume.getAbbreviatedPath()), "Volume");
        }
        if (null != this.readonly) {
            dict.setStringForKey(String.valueOf(this.readonly), "Readonly");
        }
        if (null != this.custom) {
            dict.setMapForKey(this.custom, "Custom");
        }
        return dict.getSerialized();
    }

    public String getDefaultPath() {
        return this.defaultpath;
    }

    public void setDefaultPath(String defaultpath) {
        this.defaultpath = StringUtils.isBlank((CharSequence)defaultpath) ? null : StringUtils.trim((String)defaultpath);
    }

    public Path getWorkdir() {
        return this.workdir;
    }

    public void setWorkdir(Path workdir) {
        this.workdir = workdir;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCdnCredentials() {
        return this.cloudfront;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getUuid() {
        if (null == this.uuid) {
            this.uuid = new UUIDRandomStringService().random();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname.trim();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = -1 == port ? this.protocol.getDefaultPort() : port;
    }

    public String getEncoding() {
        if (null == this.encoding) {
            return PreferencesFactory.get().getProperty("browser.charset.encoding");
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FTPConnectMode getFTPConnectMode() {
        return this.connectMode;
    }

    public void setFTPConnectMode(FTPConnectMode connectMode) {
        this.connectMode = connectMode;
    }

    public TransferType getTransferType() {
        switch (this.transfer) {
            case unknown: {
                return TransferType.valueOf(PreferencesFactory.get().getProperty("queue.transfer.type"));
            }
        }
        return this.transfer;
    }

    public void setTransfer(TransferType transfer) {
        this.transfer = transfer;
    }

    public Local getDownloadFolder() {
        return this.downloadFolder;
    }

    public void setDownloadFolder(Local folder) {
        this.downloadFolder = folder;
    }

    public Local getUploadFolder() {
        return this.uploadFolder;
    }

    public void setUploadFolder(Local folder) {
        this.uploadFolder = folder;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public String getRegion() {
        if (StringUtils.isBlank((CharSequence)this.region)) {
            return this.protocol.getRegion();
        }
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getWebURL() {
        return this.webURL;
    }

    public void setWebURL(String url) {
        this.webURL = url;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Local getVolume() {
        return this.volume;
    }

    public void setVolume(Local volume) {
        this.volume = volume;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, String> custom) {
        this.custom = custom;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Host) {
            return this.getUuid().equals(((Host)other).getUuid());
        }
        return false;
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    @Override
    public int compareTo(Host o) {
        if (this.protocol.compareTo(o.protocol) < 0) {
            return -1;
        }
        if (this.protocol.compareTo(o.protocol) > 0) {
            return 1;
        }
        if (this.port.compareTo(o.port) < 0) {
            return -1;
        }
        if (this.port.compareTo(o.port) > 0) {
            return 1;
        }
        if (this.hostname.compareTo(o.hostname) < 0) {
            return -1;
        }
        if (this.hostname.compareTo(o.hostname) > 0) {
            return 1;
        }
        if (this.credentials.compareTo(o.credentials) < 0) {
            return -1;
        }
        if (this.credentials.compareTo(o.credentials) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Host{");
        sb.append("credentials=").append(this.credentials);
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", defaultpath='").append(this.defaultpath).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", protocol=").append(this.protocol);
        sb.append('}');
        return sb.toString();
    }

    public static enum TransferType {
        unknown{

            public String toString() {
                return LocaleFactory.localizedString("Default");
            }
        }
        ,
        browser{

            public String toString() {
                return LocaleFactory.localizedString("Use browser connection", "Transfer");
            }
        }
        ,
        newconnection{

            public String toString() {
                return LocaleFactory.localizedString("Open single connection", "Transfer");
            }
        }
        ,
        concurrent{

            public String toString() {
                return LocaleFactory.localizedString("Open multiple connections", "Transfer");
            }
        }
        ,
        udt{

            public String toString() {
                return LocaleFactory.localizedString("Qloudsonic (UDP-based Data Transfer Protocol)", "Transfer");
            }
        };

    }
}

