/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import synapticloop.b2.BucketType;
import synapticloop.b2.LifecycleRule;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.B2AuthorizeAccountRequest;
import synapticloop.b2.request.B2CancelLargeFileRequest;
import synapticloop.b2.request.B2CreateBucketRequest;
import synapticloop.b2.request.B2DeleteBucketRequest;
import synapticloop.b2.request.B2DeleteFileVersionRequest;
import synapticloop.b2.request.B2DownloadFileByIdRequest;
import synapticloop.b2.request.B2DownloadFileByNameRequest;
import synapticloop.b2.request.B2FinishLargeFileRequest;
import synapticloop.b2.request.B2GetDownloadAuthorizationRequest;
import synapticloop.b2.request.B2GetFileInfoRequest;
import synapticloop.b2.request.B2GetUploadPartUrlRequest;
import synapticloop.b2.request.B2GetUploadUrlRequest;
import synapticloop.b2.request.B2HeadFileByIdRequest;
import synapticloop.b2.request.B2HideFileRequest;
import synapticloop.b2.request.B2ListBucketsRequest;
import synapticloop.b2.request.B2ListFileNamesRequest;
import synapticloop.b2.request.B2ListFileVersionsRequest;
import synapticloop.b2.request.B2ListPartsRequest;
import synapticloop.b2.request.B2ListUnfinishedLargeFilesRequest;
import synapticloop.b2.request.B2StartLargeFileRequest;
import synapticloop.b2.request.B2UpdateBucketRequest;
import synapticloop.b2.request.B2UploadFileRequest;
import synapticloop.b2.request.B2UploadPartRequest;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2DeleteFileVersionResponse;
import synapticloop.b2.response.B2DownloadFileResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.B2GetUploadPartUrlResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.response.B2HideFileResponse;
import synapticloop.b2.response.B2ListFilesResponse;
import synapticloop.b2.response.B2ListPartsResponse;
import synapticloop.b2.response.B2StartLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;
import synapticloop.b2.util.ChecksumHelper;

public class B2ApiClient {
    private B2AuthorizeAccountResponse b2AuthorizeAccountResponse;
    private final CloseableHttpClient client;

    public B2ApiClient(String accountId, String applicationKey) throws B2ApiException, IOException {
        this();
        this.b2AuthorizeAccountResponse = this.authenticate(accountId, applicationKey);
    }

    public B2ApiClient() {
        this(HttpClients.createDefault());
    }

    public B2ApiClient(CloseableHttpClient client) {
        this.client = client;
    }

    public B2AuthorizeAccountResponse authenticate(String accountId, String applicationKey) throws B2ApiException, IOException {
        this.b2AuthorizeAccountResponse = new B2AuthorizeAccountRequest(this.client, accountId, applicationKey).getResponse();
        return this.b2AuthorizeAccountResponse;
    }

    public String getDownloadUrl() {
        return this.b2AuthorizeAccountResponse.getDownloadUrl();
    }

    public String getApiUrl() {
        return this.b2AuthorizeAccountResponse.getApiUrl();
    }

    public void close() throws IOException {
        this.client.close();
    }

    public B2BucketResponse createBucket(String bucketName, BucketType bucketType) throws B2ApiException, IOException {
        return new B2CreateBucketRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, bucketType).getResponse();
    }

    public B2BucketResponse deleteBucket(String bucketId) throws B2ApiException, IOException {
        return new B2DeleteBucketRequest(this.client, this.b2AuthorizeAccountResponse, bucketId).getResponse();
    }

    public B2BucketResponse updateBucket(String bucketId, BucketType bucketType, LifecycleRule ... lifecycleRules) throws B2ApiException, IOException {
        return new B2UpdateBucketRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, bucketType, lifecycleRules).getResponse();
    }

    public List<B2BucketResponse> listBuckets() throws B2ApiException, IOException {
        return new B2ListBucketsRequest(this.client, this.b2AuthorizeAccountResponse).getResponse().getBuckets();
    }

    public B2FileResponse getFileInfo(String fileId) throws B2ApiException, IOException {
        return new B2GetFileInfoRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse();
    }

    public B2DownloadFileResponse headFileById(String fileId) throws B2ApiException, IOException {
        return new B2HeadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse();
    }

    public B2GetUploadUrlResponse getUploadUrl(String bucketId) throws B2ApiException, IOException {
        return new B2GetUploadUrlRequest(this.client, this.b2AuthorizeAccountResponse, bucketId).getResponse();
    }

    public B2FileResponse uploadFile(String bucketId, String fileName, HttpEntity entity, String sha1Checksum, String mimeType, Map<String, String> fileInfo) throws B2ApiException, IOException {
        B2GetUploadUrlResponse b2GetUploadUrlResponse = this.getUploadUrl(bucketId);
        return this.uploadFile(b2GetUploadUrlResponse, fileName, entity, sha1Checksum, mimeType, fileInfo);
    }

    public B2FileResponse uploadFile(B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, HttpEntity entity, String sha1Checksum, String mimeType, Map<String, String> fileInfo) throws B2ApiException, IOException {
        return new B2UploadFileRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, entity, sha1Checksum, mimeType, fileInfo).getResponse();
    }

    public B2FileResponse uploadFile(String bucketId, String fileName, File file, String mimeType, Map<String, String> fileInfo) throws B2ApiException, IOException {
        B2GetUploadUrlResponse b2GetUploadUrlResponse = this.getUploadUrl(bucketId);
        return this.uploadFile(b2GetUploadUrlResponse, fileName, file, mimeType, fileInfo);
    }

    public B2FileResponse uploadFile(B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String mimeType, Map<String, String> fileInfo) throws B2ApiException, IOException {
        return new B2UploadFileRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, ChecksumHelper.calculateSha1(file), mimeType, fileInfo).getResponse();
    }

    public B2FileResponse uploadFile(String bucketId, String fileName, File file, Map<String, String> fileInfo) throws B2ApiException, IOException {
        B2GetUploadUrlResponse b2GetUploadUrlResponse = this.getUploadUrl(bucketId);
        return this.uploadFile(b2GetUploadUrlResponse, fileName, file, fileInfo);
    }

    public B2FileResponse uploadFile(B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, Map<String, String> fileInfo) throws B2ApiException, IOException {
        return new B2UploadFileRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, ChecksumHelper.calculateSha1(file), fileInfo).getResponse();
    }

    public B2FileResponse uploadFile(String bucketId, String fileName, File file, String mimeType) throws B2ApiException, IOException {
        B2GetUploadUrlResponse b2GetUploadUrlResponse = this.getUploadUrl(bucketId);
        return this.uploadFile(b2GetUploadUrlResponse, fileName, file, mimeType);
    }

    public B2FileResponse uploadFile(B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String mimeType) throws B2ApiException, IOException {
        return new B2UploadFileRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, ChecksumHelper.calculateSha1(file), mimeType).getResponse();
    }

    public B2FileResponse uploadFile(String bucketId, String fileName, File file) throws B2ApiException, IOException {
        B2GetUploadUrlResponse b2GetUploadUrlResponse = this.getUploadUrl(bucketId);
        return this.uploadFile(b2GetUploadUrlResponse, fileName, file);
    }

    public B2FileResponse uploadFile(B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file) throws B2ApiException, IOException {
        return new B2UploadFileRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, ChecksumHelper.calculateSha1(file)).getResponse();
    }

    public B2GetUploadPartUrlResponse getUploadPartUrl(String fileId) throws B2ApiException, IOException {
        return new B2GetUploadPartUrlRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse();
    }

    public B2StartLargeFileResponse startLargeFileUpload(String bucketId, String fileName, String mimeType, Map<String, String> fileInfo) throws B2ApiException, IOException {
        return new B2StartLargeFileRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, fileName, mimeType, fileInfo).getResponse();
    }

    public B2FileResponse cancelLargeFileUpload(String fileId) throws B2ApiException, IOException {
        return new B2CancelLargeFileRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse();
    }

    public B2FinishLargeFileResponse finishLargeFileUpload(String fileId, String[] partSha1Array) throws B2ApiException, IOException {
        return new B2FinishLargeFileRequest(this.client, this.b2AuthorizeAccountResponse, fileId, partSha1Array).getResponse();
    }

    public B2UploadPartResponse uploadLargeFilePart(String fileId, int partNumber, HttpEntity entity, String sha1Checksum) throws B2ApiException, IOException {
        B2GetUploadPartUrlResponse b2GetUploadUrlResponse = this.getUploadPartUrl(fileId);
        return this.uploadLargeFilePart(b2GetUploadUrlResponse, partNumber, entity, sha1Checksum);
    }

    public B2UploadPartResponse uploadLargeFilePart(B2GetUploadPartUrlResponse b2GetUploadUrlResponse, int partNumber, HttpEntity entity, String sha1Checksum) throws B2ApiException, IOException {
        return new B2UploadPartRequest(this.client, this.b2AuthorizeAccountResponse, b2GetUploadUrlResponse, partNumber, entity, sha1Checksum).getResponse();
    }

    public B2ListFilesResponse listUnfinishedLargeFiles(String bucketId, String startFileId, Integer maxFileCount) throws B2ApiException, IOException {
        return new B2ListUnfinishedLargeFilesRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, startFileId, maxFileCount).getResponse();
    }

    public B2ListPartsResponse listParts(String fileId, Integer startPartNumber, Integer maxPartCount) throws B2ApiException, IOException {
        return new B2ListPartsRequest(this.client, this.b2AuthorizeAccountResponse, fileId, startPartNumber, maxPartCount).getResponse();
    }

    public B2DeleteFileVersionResponse deleteFileVersion(String fileName, String fileId) throws B2ApiException, IOException {
        return new B2DeleteFileVersionRequest(this.client, this.b2AuthorizeAccountResponse, fileName, fileId).getResponse();
    }

    public B2HideFileResponse hideFile(String bucketId, String fileName) throws B2ApiException, IOException {
        return new B2HideFileRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, fileName).getResponse();
    }

    public B2ListFilesResponse listFileNames(String bucketId) throws B2ApiException, IOException {
        return new B2ListFileNamesRequest(this.client, this.b2AuthorizeAccountResponse, bucketId).getResponse();
    }

    public B2ListFilesResponse listFileNames(String bucketId, String startFileName, Integer maxFileCount) throws B2ApiException, IOException {
        return new B2ListFileNamesRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, startFileName, maxFileCount, null, null).getResponse();
    }

    public B2ListFilesResponse listFileNames(String bucketId, String startFileName, Integer maxFileCount, String prefix, String delimiter) throws B2ApiException, IOException {
        return new B2ListFileNamesRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, startFileName, maxFileCount, prefix, delimiter).getResponse();
    }

    public B2ListFilesResponse listFileVersions(String bucketId) throws B2ApiException, IOException {
        return new B2ListFileVersionsRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, 1000).getResponse();
    }

    public B2ListFilesResponse listFileVersions(String bucketId, String startFileName) throws B2ApiException, IOException {
        return new B2ListFileVersionsRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, null, startFileName, null, null, null).getResponse();
    }

    public B2ListFilesResponse listFileVersions(String bucketId, String startFileName, String startFileId, Integer maxFileCount) throws B2ApiException, IOException {
        return new B2ListFileVersionsRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, maxFileCount, startFileName, startFileId, null, null).getResponse();
    }

    public B2ListFilesResponse listFileVersions(String bucketId, String startFileName, String startFileId, Integer maxFileCount, String prefix, String delimiter) throws B2ApiException, IOException {
        return new B2ListFileVersionsRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, maxFileCount, startFileName, startFileId, prefix, delimiter).getResponse();
    }

    public String getDownloadAuthorization(String bucketId, String fileNamePrefix, Integer validDurationInSeconds) throws B2ApiException, IOException {
        return new B2GetDownloadAuthorizationRequest(this.client, this.b2AuthorizeAccountResponse, bucketId, fileNamePrefix, validDurationInSeconds).getResponse().getAuthorizationToken();
    }

    public void downloadFileByNameToFile(String bucketName, String fileName, File file) throws B2ApiException, IOException {
        FileUtils.copyInputStreamToFile((InputStream)new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName).getResponse().getContent(), (File)file);
    }

    public void downloadFileRangeByNameToFile(String bucketName, String fileName, File file, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        FileUtils.copyInputStreamToFile((InputStream)new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName).getResponse().getContent(), (File)file);
    }

    public InputStream downloadFileByNameToStream(String bucketName, String fileName) throws B2ApiException, IOException {
        return new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName).getResponse().getContent();
    }

    public InputStream downloadFileRangeByNameToStream(String bucketName, String fileName, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        return new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName).getResponse().getContent();
    }

    public B2DownloadFileResponse downloadFileByName(String bucketName, String fileName) throws B2ApiException, IOException {
        return new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName).getResponse();
    }

    public B2DownloadFileResponse downloadFileRangeByName(String bucketName, String fileName, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        return new B2DownloadFileByNameRequest(this.client, this.b2AuthorizeAccountResponse, bucketName, fileName, rangeStart, rangeEnd).getResponse();
    }

    public B2DownloadFileResponse downloadFileById(String fileId) throws B2ApiException, IOException {
        return new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse();
    }

    public B2DownloadFileResponse downloadFileRangeById(String fileId, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        return new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId, rangeStart, rangeEnd).getResponse();
    }

    public void downloadFileByIdToFile(String fileId, File file) throws B2ApiException, IOException {
        FileUtils.copyInputStreamToFile((InputStream)new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse().getContent(), (File)file);
    }

    public void downloadFileRangeByIdToFile(String fileId, File file, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        FileUtils.copyInputStreamToFile((InputStream)new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId, rangeStart, rangeEnd).getResponse().getContent(), (File)file);
    }

    public InputStream downloadFileByIdToStream(String fileId) throws B2ApiException, IOException {
        return new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId).getResponse().getContent();
    }

    public InputStream downloadFileRangeByIdToStream(String fileId, long rangeStart, long rangeEnd) throws B2ApiException, IOException {
        return new B2DownloadFileByIdRequest(this.client, this.b2AuthorizeAccountResponse, fileId, rangeStart, rangeEnd).getResponse().getContent();
    }
}

