/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.collections4.map.UnmodifiableMap;

public class LookupMap<String, V>
implements Map<String, V> {
    private final Map<String, V> wrapped;
    private final CaseInsensitiveMap<String, V> lowercaseWrapped;

    public LookupMap(Map<String, V> backingMap) {
        this.wrapped = this.isUnmodifiable(backingMap) ? backingMap : Collections.unmodifiableMap(backingMap);
        this.lowercaseWrapped = new CaseInsensitiveMap(this.wrapped);
    }

    private boolean isUnmodifiable(Map<String, V> map) {
        return map.getClass().getName().equals("java.util.Collections$UnmodifiableMap") || map.getClass().getName().equals("org.apache.commons.collections4.map.UnmodifiableMap") || map.getClass().getName().equals("com.google.common.collect.ImmutableMap") || map instanceof UnmodifiableMap;
    }

    public Set<String> lowercaseKeySet() {
        return this.lowercaseWrapped.keySet();
    }

    public boolean containsKeyCaseInsensitive(String key) {
        return this.lowercaseWrapped.containsKey(key);
    }

    public V getWithCaseInsensitiveKey(String key) {
        return (V)this.lowercaseWrapped.get(key);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public V put(String key, V value) {
        return this.wrapped.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.wrapped.putAll(m);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.wrapped.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super V> action) {
        this.wrapped.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
        this.wrapped.replaceAll(function);
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return this.wrapped.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.wrapped.remove(key, value);
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        return this.wrapped.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(String key, V value) {
        return this.wrapped.replace(key, value);
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return this.wrapped.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.compute(key, remappingFunction);
    }

    @Override
    public V merge(String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.wrapped.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

