/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.crypto.SupportedHmacsLookupMap;
import com.joyent.manta.exception.MantaClientEncryptionCiphertextAuthenticationException;
import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.util.NotThreadSafe;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Supplier;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MantaEncryptedObjectInputStream
extends MantaObjectInputStream {
    private static final long serialVersionUID = 8536248985759134599L;
    private static final int EOF = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaEncryptedObjectInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final SupportedCipherDetails cipherDetails;
    private final SecretKey secretKey;
    private final Cipher cipher;
    private final HMac hmac;
    private final InputStream cipherInputStream;
    private long plaintextBytesRead = 0L;
    private volatile boolean closed = false;
    private final Object closeLock = new Object();
    private final boolean authenticateCiphertext;
    private final Long startPosition;
    private final Long plaintextRangeLength;
    private final Long contentLength;
    private final boolean unboundedEnd;
    private long initialBytesToSkip;

    public MantaEncryptedObjectInputStream(MantaObjectInputStream backingStream, SupportedCipherDetails cipherDetails, SecretKey secretKey, boolean authenticateCiphertext) {
        this(backingStream, cipherDetails, secretKey, authenticateCiphertext, null, null, true);
    }

    public MantaEncryptedObjectInputStream(MantaObjectInputStream backingStream, SupportedCipherDetails cipherDetails, SecretKey secretKey, boolean authenticateCiphertext, Long startPositionInclusive, Long plaintextRangeLength, boolean unboundedEnd) {
        super(backingStream);
        this.authenticateCiphertext = authenticateCiphertext;
        this.startPosition = startPositionInclusive;
        this.plaintextRangeLength = plaintextRangeLength;
        this.cipherDetails = cipherDetails;
        this.contentLength = super.getContentLength();
        this.unboundedEnd = unboundedEnd;
        if (!(startPositionInclusive == null && plaintextRangeLength == null || cipherDetails.supportsRandomAccess())) {
            String msg = "Cipher and cipher mode specified doesn't support random access";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            this.annotateException((ExceptionContext)e);
            throw e;
        }
        this.cipher = cipherDetails.getCipher();
        this.secretKey = secretKey;
        this.hmac = this.findHmac();
        this.initialBytesToSkip = this.initializeCipher();
        this.cipherInputStream = this.createCryptoStream();
        this.initializeHmac();
    }

    private void initializeHmac() {
        if (this.hmac == null) {
            return;
        }
        this.hmac.init((CipherParameters)new KeyParameter(this.secretKey.getEncoded()));
        byte[] iv = this.cipher.getIV();
        this.hmac.update(iv, 0, iv.length);
    }

    private long initializeCipher() {
        String ivString = this.getHeaderAsString("m-encrypt-iv");
        if (ivString == null || ivString.isEmpty()) {
            String msg = "Initialization Vector (IV) was not set for the object. Unable to decrypt.";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            this.annotateException((ExceptionContext)e);
            throw e;
        }
        byte[] iv = Base64.getDecoder().decode(ivString);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("IV: {}", (Object)Hex.encodeHexString((byte[])iv));
        }
        int mode = 2;
        try {
            this.cipher.init(2, (Key)this.secretKey, this.cipherDetails.getEncryptionParameterSpec(iv));
            if (this.startPosition != null && this.startPosition > 0L) {
                return this.cipherDetails.updateCipherToPosition(this.cipher, this.startPosition);
            }
            return 0L;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            String msg = "Error initializing cipher";
            MantaClientEncryptionException mce = new MantaClientEncryptionException(msg, e);
            this.annotateException((ExceptionContext)mce);
            throw mce;
        }
    }

    private InputStream createCryptoStream() {
        InputStream source;
        boolean isRangeRequest;
        boolean bl = isRangeRequest = this.plaintextRangeLength != null && this.plaintextRangeLength > 0L;
        if (this.cipherDetails.isAEADCipher()) {
            source = super.getBackingStream();
        } else {
            long hmacSize = this.hmac == null ? (long)this.cipherDetails.getAuthenticationTagOrHmacLengthInBytes() : (long)this.hmac.getMacSize();
            long adjustedContentLength = !isRangeRequest || this.unboundedEnd ? this.contentLength - hmacSize : this.contentLength;
            BoundedInputStream bin = new BoundedInputStream(super.getBackingStream(), adjustedContentLength);
            bin.setPropagateClose(false);
            source = bin;
        }
        CipherInputStream cin = new CipherInputStream(source, this.cipher);
        if (!isRangeRequest) {
            return cin;
        }
        return new BoundedInputStream((InputStream)cin, this.plaintextRangeLength + this.initialBytesToSkip);
    }

    private HMac findHmac() {
        if (this.cipherDetails.isAEADCipher() || !this.authenticateCiphertext) {
            return null;
        }
        String hmacString = this.getHeaderAsString("m-encrypt-hmac-type");
        if (hmacString == null) {
            String msg = String.format("HMAC header metadata [%s] was missing from object", "m-encrypt-hmac-type");
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            this.annotateException((ExceptionContext)e);
            throw e;
        }
        if (hmacString.isEmpty()) {
            String msg = String.format("HMAC header metadata [%s] was empty on object", "m-encrypt-hmac-type");
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            this.annotateException((ExceptionContext)e);
            throw e;
        }
        Supplier macSupplier = (Supplier)SupportedHmacsLookupMap.INSTANCE.get(hmacString);
        if (macSupplier == null) {
            String msg = String.format("HMAC stored in header metadata [%s] is unsupported", hmacString);
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            this.annotateException((ExceptionContext)e);
            throw e;
        }
        return (HMac)macSupplier.get();
    }

    @Override
    public InputStream getBackingStream() {
        return this.cipherInputStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark is not a supported operation on " + this.getClass());
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset is not a supported operation on " + this.getClass());
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            MantaIOException e = new MantaIOException("Can't read a closed stream");
            this.annotateException(e);
            throw e;
        }
        this.skipInitialBytes();
        try {
            int read = this.cipherInputStream.read();
            if (this.hmac != null && read > -1 && this.authenticateCiphertext) {
                this.hmac.update((byte)read);
            }
            if (read > -1) {
                ++this.plaintextBytesRead;
            }
            return read;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getClass().equals(AEADBadTagException.class)) {
                MantaClientEncryptionCiphertextAuthenticationException mce = new MantaClientEncryptionCiphertextAuthenticationException(cause);
                this.annotateException((ExceptionContext)mce);
                throw mce;
            }
            MantaIOException mioe = new MantaIOException("Error reading from cipher stream", e);
            this.annotateException(mioe);
            throw mioe;
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, true);
    }

    private int read(byte[] bytes, boolean checkIfClosed) throws IOException {
        int read;
        if (this.closed && checkIfClosed) {
            MantaIOException e = new MantaIOException("Can't read a closed stream");
            e.setContextValue("path", this.getPath());
            throw e;
        }
        this.skipInitialBytes();
        try {
            read = this.cipherInputStream.read(bytes);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getClass().equals(AEADBadTagException.class)) {
                MantaClientEncryptionCiphertextAuthenticationException mce = new MantaClientEncryptionCiphertextAuthenticationException(cause);
                this.annotateException((ExceptionContext)mce);
                throw mce;
            }
            MantaIOException mioe = new MantaIOException("Error reading from cipher stream", e);
            this.annotateException(mioe);
            throw mioe;
        }
        if (this.hmac != null && read > -1 && this.authenticateCiphertext) {
            this.hmac.update(bytes, 0, read);
        }
        if (read > -1) {
            this.plaintextBytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            MantaIOException e = new MantaIOException("Can't read a closed stream");
            e.setContextValue("path", this.getPath());
            throw e;
        }
        this.skipInitialBytes();
        try {
            int read = this.cipherInputStream.read(bytes, off, len);
            if (this.hmac != null && read > -1 && this.authenticateCiphertext) {
                this.hmac.update(bytes, off, read);
            }
            if (read > -1) {
                this.plaintextBytesRead += (long)read;
            }
            return read;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getClass().equals(AEADBadTagException.class)) {
                MantaClientEncryptionCiphertextAuthenticationException mce = new MantaClientEncryptionCiphertextAuthenticationException(cause);
                this.annotateException((ExceptionContext)mce);
                throw mce;
            }
            MantaIOException mioe = new MantaIOException("Error reading from cipher stream", e);
            this.annotateException(mioe);
            throw mioe;
        }
    }

    @Override
    public long skip(long numberOfBytesToSkip) throws IOException {
        if (this.closed) {
            MantaIOException e = new MantaIOException("Can't skip a closed stream");
            e.setContextValue("path", this.getPath());
            throw e;
        }
        this.skipInitialBytes();
        if (numberOfBytesToSkip <= 0L) {
            return 0L;
        }
        if (!this.authenticateCiphertext || this.cipherDetails.isAEADCipher()) {
            long skipped = 0L;
            for (long l = 0L; l < numberOfBytesToSkip; ++l) {
                try {
                    int read = this.cipherInputStream.read();
                    if (read <= -1) continue;
                    ++skipped;
                    continue;
                }
                catch (IOException e) {
                    MantaIOException mioe = new MantaIOException("Error reading from cipher stream", e);
                    this.annotateException(mioe);
                    throw mioe;
                }
            }
            return skipped;
        }
        int defaultBufferSize = MantaEncryptedObjectInputStream.calculateBufferSize(this.getContentLength(), this.cipherDetails);
        int bufferSize = numberOfBytesToSkip < (long)defaultBufferSize ? (int)numberOfBytesToSkip : defaultBufferSize;
        byte[] buf = new byte[bufferSize];
        long skipped = 0L;
        int skippedInLastRead = 0;
        while (skippedInLastRead > -1 && skipped <= numberOfBytesToSkip) {
            long bytesRemaining = numberOfBytesToSkip - skipped;
            skippedInLastRead = bytesRemaining == 0L ? this.read() : (bytesRemaining < (long)buf.length ? this.read(buf, 0, (int)bytesRemaining) : this.read(buf));
            if (skippedInLastRead <= -1) continue;
            skipped += (long)skippedInLastRead;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            MantaIOException e = new MantaIOException("Can't calculate available on a closed stream");
            e.setContextValue("path", this.getPath());
            throw e;
        }
        this.skipInitialBytes();
        return this.cipherInputStream.available();
    }

    private void skipInitialBytes() throws IOException {
        while (this.initialBytesToSkip > 0L) {
            int read = this.cipherInputStream.read();
            if (read > -1) {
                --this.initialBytesToSkip;
                continue;
            }
            this.initialBytesToSkip = 0L;
            return;
        }
    }

    private void readRemainingBytes() throws IOException {
        if (this.cipherInputStream.available() <= 0) {
            return;
        }
        int bufferSize = MantaEncryptedObjectInputStream.calculateBufferSize(this.getContentLength(), this.cipherDetails);
        byte[] buf = new byte[bufferSize];
        while (this.read(buf, false) > -1) {
        }
    }

    static int calculateBufferSize(Long contentLength, SupportedCipherDetails cipherDetails) {
        long cipherTextContentLength = (Long)ObjectUtils.firstNonNull((Object[])new Long[]{contentLength, -1L});
        if (cipherTextContentLength >= 0L) {
            cipherTextContentLength -= (long)cipherDetails.getAuthenticationTagOrHmacLengthInBytes();
        }
        int bufferSize = cipherTextContentLength > 512L || cipherTextContentLength < 0L ? 512 : (int)cipherTextContentLength;
        return bufferSize;
    }

    private byte[] readHmacFromEndOfStream() throws MantaIOException {
        int bytesRead;
        InputStream stream = super.getBackingStream();
        int hmacSize = this.hmac.getMacSize();
        byte[] hmacBytes = new byte[hmacSize];
        for (int totalBytesRead = 0; totalBytesRead < hmacSize; totalBytesRead += bytesRead) {
            int lengthToRead = hmacSize - totalBytesRead;
            try {
                bytesRead = stream.read(hmacBytes, totalBytesRead, lengthToRead);
            }
            catch (IOException e) {
                String msg = "Unable to read HMAC from the end of stream";
                MantaIOException mioe = new MantaIOException(msg);
                this.annotateException(mioe);
                mioe.setContextValue("backingStreamClass", stream.getClass());
                mioe.setContextValue("hmacBytesReadTotal", totalBytesRead);
                mioe.setContextValue("hmacBytesExpected", hmacSize);
                throw mioe;
            }
            if (totalBytesRead >= hmacSize || bytesRead != -1) continue;
            String msg = "No HMAC was stored at the end of the stream";
            MantaIOException e = new MantaIOException(msg);
            this.annotateException(e);
            throw e;
        }
        return hmacBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.readRemainingBytes();
        try {
            this.cipherInputStream.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing CipherInputStream", (Throwable)e);
        }
        try {
            if (this.hmac != null && this.authenticateCiphertext) {
                byte[] checksum = new byte[this.hmac.getMacSize()];
                this.hmac.doFinal(checksum, 0);
                byte[] expected = this.readHmacFromEndOfStream();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Calculated HMAC is: {}", (Object)Hex.encodeHexString((byte[])checksum));
                }
                if (super.getBackingStream().read() >= 0) {
                    MantaIOException e = new MantaIOException("More bytes were available than the expected HMAC length");
                    this.annotateException(e);
                    throw e;
                }
                if (!Arrays.equals(expected, checksum)) {
                    MantaClientEncryptionCiphertextAuthenticationException e = new MantaClientEncryptionCiphertextAuthenticationException();
                    this.annotateException((ExceptionContext)e);
                    e.setContextValue("expected", Hex.encodeHexString((byte[])expected));
                    e.setContextValue("checksum", Hex.encodeHexString((byte[])checksum));
                    throw e;
                }
            }
        }
        finally {
            super.close();
        }
    }

    private void annotateException(ExceptionContext exception) {
        exception.setContextValue("path", (Object)this.getPath());
        exception.setContextValue("etag", (Object)this.getEtag());
        exception.setContextValue("lastModified", (Object)this.getLastModifiedTime());
        exception.setContextValue("ciphertextContentLength", (Object)super.getContentLength());
        exception.setContextValue("plaintextContentLength", (Object)this.getContentLength());
        exception.setContextValue("plaintextBytesRead", (Object)this.plaintextBytesRead);
        exception.setContextValue("cipherId", (Object)this.getHeaderAsString("m-encrypt-cipher"));
        exception.setContextValue("cipherDetails", (Object)this.cipherDetails);
        exception.setContextValue("cipherInputStream", (Object)this.cipherInputStream);
        exception.setContextValue("authenticationEnabled", (Object)this.authenticateCiphertext);
        exception.setContextValue("threadName", (Object)Thread.currentThread().getName());
        exception.setContextValue("requestId", (Object)this.getRequestId());
        if (this.cipher != null && this.cipher.getIV() != null) {
            exception.setContextValue("iv", (Object)Hex.encodeHexString((byte[])this.cipher.getIV()));
        }
        if (this.hmac != null) {
            exception.setContextValue("hmacAlgorithm", (Object)this.hmac.getAlgorithmName());
        } else {
            exception.setContextValue("hmacAlgorithm", (Object)"null");
        }
    }

    @Override
    public String getContentType() {
        return this.getMetadata().getOrDefault((Object)"e-content-length", super.getContentType());
    }

    @Override
    public Long getContentLength() {
        String plaintextLengthString = this.getHeaderAsString("m-encrypt-plaintext-content-length");
        if (plaintextLengthString != null) {
            return Long.parseLong(plaintextLengthString);
        }
        if (this.closed) {
            return this.plaintextBytesRead;
        }
        if (LOGGER.isInfoEnabled() && this.cipherDetails.plaintextSizeCalculationIsAnEstimate()) {
            LOGGER.info("Plaintext size reported may be inaccurate for object: {}", (Object)this.getPath());
        }
        Long plaintextSize = super.getContentLength();
        Validate.notNull((Object)plaintextSize, (String)"Content-length header wasn't set by server", (Object[])new Object[0]);
        return this.cipherDetails.plaintextSize(plaintextSize);
    }
}

