/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.crypto;

import com.joyent.http.signature.CryptoException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.Digest;

public class JceDigest
implements Digest {
    private final MessageDigest messageDigest;

    public JceDigest(String algorithm) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Can't find digest algorithm [" + algorithm + "]", e);
        }
    }

    public JceDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public String getAlgorithmName() {
        return this.messageDigest.getAlgorithm();
    }

    public int getDigestSize() {
        return this.messageDigest.getDigestLength();
    }

    public void update(byte in) {
        this.messageDigest.update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.messageDigest.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        try {
            return this.messageDigest.digest(out, outOff, out.length - outOff);
        }
        catch (DigestException e) {
            throw new CryptoException("Can't finalize digest", e);
        }
    }

    public void reset() {
        this.messageDigest.reset();
    }
}

