/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import java.util.List;
import org.apache.log4j.Logger;

public class SDSDeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(SDSDeleteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSDeleteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            try {
                new NodesApi((ApiClient)this.session.getClient()).deleteNode(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), "");
            }
            catch (ApiException e) {
                throw new SDSExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        if (this.containerService.isContainer(file)) {
            if (PreferencesFactory.get().getBoolean("sds.delete.dataroom.enable")) {
                new SDSPermissionsFeature(this.session, this.nodeid).containsRole(file, SDSPermissionsFeature.MANAGE_ROLE);
            }
            return false;
        }
        return new SDSPermissionsFeature(this.session, this.nodeid).containsRole(file, SDSPermissionsFeature.DELETE_ROLE);
    }

    public boolean isRecursive() {
        return true;
    }
}

