/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.blobstrategy;

import com.spectralogic.ds3client.exceptions.Ds3NoMoreRetriesException;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryBehavior;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class MaxChunkAttemptsRetryBehavior
implements ChunkAttemptRetryBehavior {
    private final int maxAttempts;
    private final AtomicInteger currentAttempt = new AtomicInteger(0);

    public MaxChunkAttemptsRetryBehavior(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Override
    public void invoke() throws IOException {
        if (this.currentAttempt.incrementAndGet() > this.maxAttempts) {
            throw new Ds3NoMoreRetriesException(this.maxAttempts);
        }
    }

    @Override
    public void reset() {
        this.currentAttempt.set(0);
    }
}

