/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataIsolationLevel;
import com.spectralogic.ds3client.models.DataPersistenceRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutDataPersistenceRuleSpectraS3Request
extends AbstractRequest {
    private final String dataPolicyId;
    private final DataIsolationLevel isolationLevel;
    private final String storageDomainId;
    private final DataPersistenceRuleType type;
    private Integer minimumDaysToRetain;

    public PutDataPersistenceRuleSpectraS3Request(UUID dataPolicyId, DataIsolationLevel isolationLevel, UUID storageDomainId, DataPersistenceRuleType type) {
        this.dataPolicyId = dataPolicyId.toString();
        this.isolationLevel = isolationLevel;
        this.storageDomainId = storageDomainId.toString();
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("isolation_level", isolationLevel);
        this.updateQueryParam("storage_domain_id", storageDomainId);
        this.updateQueryParam("type", type);
    }

    public PutDataPersistenceRuleSpectraS3Request(String dataPolicyId, DataIsolationLevel isolationLevel, String storageDomainId, DataPersistenceRuleType type) {
        this.dataPolicyId = dataPolicyId;
        this.isolationLevel = isolationLevel;
        this.storageDomainId = storageDomainId;
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("isolation_level", isolationLevel);
        this.updateQueryParam("storage_domain_id", storageDomainId);
        this.updateQueryParam("type", type);
    }

    public PutDataPersistenceRuleSpectraS3Request withMinimumDaysToRetain(Integer minimumDaysToRetain) {
        this.minimumDaysToRetain = minimumDaysToRetain;
        this.updateQueryParam("minimum_days_to_retain", minimumDaysToRetain);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_persistence_rule";
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public DataIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public DataPersistenceRuleType getType() {
        return this.type;
    }

    public Integer getMinimumDaysToRetain() {
        return this.minimumDaysToRetain;
    }
}

