/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ImportAzureTargetSpectraS3Request
extends AbstractRequest {
    private final String azureTarget;
    private final String cloudBucketName;
    private String dataPolicyId;
    private Priority priority;
    private String userId;

    public ImportAzureTargetSpectraS3Request(String azureTarget, String cloudBucketName) {
        this.azureTarget = azureTarget;
        this.cloudBucketName = cloudBucketName;
        this.getQueryParams().put("operation", "import");
        this.updateQueryParam("cloud_bucket_name", cloudBucketName);
    }

    public ImportAzureTargetSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportAzureTargetSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportAzureTargetSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ImportAzureTargetSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportAzureTargetSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_target/" + this.azureTarget;
    }

    public String getAzureTarget() {
        return this.azureTarget;
    }

    public String getCloudBucketName() {
        return this.cloudBucketName;
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getUserId() {
        return this.userId;
    }
}

