/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetS3TargetSpectraS3Response;
import com.spectralogic.ds3client.models.S3Target;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetS3TargetSpectraS3ResponseParser
extends AbstractResponseParser<GetS3TargetSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetS3TargetSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3Target result = XmlOutput.fromXml(inputStream, S3Target.class);
                        GetS3TargetSpectraS3Response getS3TargetSpectraS3Response = new GetS3TargetSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getS3TargetSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

