/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetCacheStateSpectraS3Response;
import com.spectralogic.ds3client.models.CacheInformation;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetCacheStateSpectraS3ResponseParser
extends AbstractResponseParser<GetCacheStateSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetCacheStateSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        CacheInformation result = XmlOutput.fromXml(inputStream, CacheInformation.class);
                        GetCacheStateSpectraS3Response getCacheStateSpectraS3Response = new GetCacheStateSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getCacheStateSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

