/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.fs;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.worker.MountWorker;
import ch.cyberduck.fs.Filesystem;
import java.util.Objects;
import org.apache.log4j.Logger;

public class FilesystemWorker
extends MountWorker {
    private static final Logger log = Logger.getLogger(FilesystemWorker.class);
    private final Filesystem fs;
    private Filesystem.Options options = Filesystem.Options.readwrite;

    public FilesystemWorker(Filesystem fs) {
        this(fs, PathCache.empty());
    }

    public FilesystemWorker(Filesystem fs, Cache<Path> cache) {
        this(fs, cache, (ListProgressListener)new DisabledListProgressListener());
    }

    public FilesystemWorker(Filesystem fs, Cache<Path> cache, ListProgressListener listener) {
        super(fs.getHost(), cache, listener);
        this.fs = fs;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Object workdir = super.run((Session)session);
        this.fs.mount((Path)workdir, this.options);
        return workdir;
    }

    public FilesystemWorker withOptions(Filesystem.Options options) {
        this.options = options;
        return this;
    }

    @Override
    public void cancel() {
        try {
            this.fs.unmount();
        }
        catch (BackgroundException e) {
            log.warn((Object)e.getMessage());
        }
        finally {
            super.cancel();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesystemWorker)) {
            return false;
        }
        FilesystemWorker that = (FilesystemWorker)o;
        return Objects.equals(this.fs, that.fs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fs);
    }
}

