/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostKeyCallbackFactory;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.LoginConnectionService;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.pool.DefaultSessionPool;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.pool.StatefulSessionPool;
import ch.cyberduck.core.pool.StatelessSessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultRegistryFactory;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SessionPoolFactory {
    private static final Logger log = Logger.getLogger(SessionPoolFactory.class);

    private SessionPoolFactory() {
    }

    public static SessionPool create(Controller controller, Cache<Path> cache, Host bookmark) {
        return SessionPoolFactory.create(controller, cache, bookmark, controller);
    }

    public static SessionPool create(Controller controller, Cache<Path> cache, Host bookmark, ProgressListener listener) {
        return SessionPoolFactory.create(controller, cache, bookmark, listener, Usage.transfer);
    }

    public static SessionPool create(Controller controller, Cache<Path> cache, Host bookmark, Usage ... usage) {
        return SessionPoolFactory.create(controller, cache, bookmark, controller, usage);
    }

    public static SessionPool create(Controller controller, Cache<Path> cache, Host bookmark, ProgressListener listener, Usage ... usage) {
        return SessionPoolFactory.create(cache, bookmark, PasswordStoreFactory.get(), LoginCallbackFactory.get(controller), HostKeyCallbackFactory.get(controller, bookmark.getProtocol()), listener, controller, usage);
    }

    public static SessionPool create(Cache<Path> cache, Host bookmark, HostPasswordStore keychain, LoginCallback login, HostKeyCallback key, ProgressListener listener, TranscriptListener transcript, Usage ... usage) {
        LoginConnectionService connect = new LoginConnectionService(login, key, keychain, listener);
        return SessionPoolFactory.create(connect, transcript, cache, bookmark, new KeychainX509TrustManager(new DefaultTrustManagerHostnameCallback(bookmark)), new KeychainX509KeyManager(bookmark), VaultRegistryFactory.create(keychain, login), usage);
    }

    public static SessionPool create(ConnectionService connect, TranscriptListener transcript, Cache<Path> cache, Host bookmark, X509TrustManager x509TrustManager, X509KeyManager x509KeyManager, VaultRegistry registry, Usage ... usage) {
        switch (bookmark.getProtocol().getType()) {
            case file: 
            case sftp: 
            case onedrive: 
            case s3: 
            case googlestorage: 
            case dropbox: 
            case googledrive: 
            case swift: 
            case dav: 
            case azure: 
            case b2: 
            case dracoon: {
                return SessionPoolFactory.stateless(connect, transcript, cache, bookmark, x509TrustManager, x509KeyManager, registry);
            }
            case ftp: 
            case irods: {
                if (!Arrays.asList(usage).contains((Object)Usage.browser)) break;
                return SessionPoolFactory.stateful(connect, transcript, cache, bookmark, x509TrustManager, x509KeyManager, registry);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create new pooled connection pool for %s", bookmark));
        }
        return new DefaultSessionPool(connect, x509TrustManager, x509KeyManager, registry, cache, transcript, bookmark).withMinIdle(PreferencesFactory.get().getInteger("connection.pool.minidle")).withMaxIdle(PreferencesFactory.get().getInteger("connection.pool.maxidle")).withMaxTotal(PreferencesFactory.get().getInteger("connection.pool.maxtotal"));
    }

    protected static SessionPool stateless(ConnectionService connect, TranscriptListener transcript, Cache<Path> cache, Host bookmark, X509TrustManager trust, X509KeyManager key, VaultRegistry vault) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create new stateless connection pool for %s", bookmark));
        }
        Session<?> session = SessionFactory.create(bookmark, trust, key);
        return new StatelessSessionPool(connect, session, cache, transcript, vault);
    }

    protected static SessionPool stateful(ConnectionService connect, TranscriptListener transcript, Cache<Path> cache, Host bookmark, X509TrustManager trust, X509KeyManager key, VaultRegistry vault) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create new stateful connection pool for %s", bookmark));
        }
        Session<?> session = SessionFactory.create(bookmark, trust, key);
        return new StatefulSessionPool(connect, session, cache, transcript, vault);
    }

    public static enum Usage {
        transfer,
        browser;

    }
}

