/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.PartialLoginFailureException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class SDSExceptionMappingService
extends AbstractExceptionMappingService<ApiException> {
    private static final Logger log = Logger.getLogger(SDSExceptionMappingService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackgroundException map(ApiException failure) {
        StringBuilder buffer;
        block35: {
            for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
                if (cause instanceof SocketException) {
                    return new DefaultSocketExceptionMappingService().map((SocketException)cause);
                }
                if (cause instanceof HttpResponseException) {
                    return new HttpResponseExceptionMappingService().map((HttpResponseException)cause);
                }
                if (cause instanceof IOException) {
                    return new DefaultIOExceptionMappingService().map((IOException)cause);
                }
                if (!(cause instanceof IllegalStateException)) continue;
                return new ConnectionCanceledException(cause);
            }
            buffer = new StringBuilder();
            if (null != failure.getResponseBody()) {
                JsonParser parser = new JsonParser();
                try {
                    JsonObject json = parser.parse((Reader)new StringReader(failure.getResponseBody())).getAsJsonObject();
                    if (json.has("errorCode")) {
                        if (json.get("errorCode").isJsonPrimitive()) {
                            int errorCode = json.getAsJsonPrimitive("errorCode").getAsInt();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Failure with errorCode %s", errorCode));
                            }
                            String key = String.format("Error %d", errorCode);
                            String localized = LocaleFactory.get().localize(key, "SDS");
                            this.append(buffer, localized);
                            if (StringUtils.equals((CharSequence)localized, (CharSequence)key)) {
                                log.warn((Object)String.format("Missing user message for error code %d", errorCode));
                                if (json.has("debugInfo") && json.get("debugInfo").isJsonPrimitive()) {
                                    this.append(buffer, json.getAsJsonPrimitive("debugInfo").getAsString());
                                }
                            }
                            switch (failure.getCode()) {
                                case 404: {
                                    switch (errorCode) {
                                        case -70501: {
                                            return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                                        }
                                        case -40761: {
                                            return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                                        }
                                    }
                                    break;
                                }
                                case 412: {
                                    switch (errorCode) {
                                        case -10108: {
                                            if (json.has("replyMessage") && json.get("replyMessage").isJsonPrimitive()) {
                                                JsonPrimitive replyMessage = json.getAsJsonPrimitive("replyMessage");
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)String.format("Failure with replyMessage %s", replyMessage));
                                                }
                                                buffer.append(replyMessage.getAsString());
                                            }
                                            return new PartialLoginFailureException(buffer.toString(), (Throwable)failure);
                                        }
                                    }
                                    break;
                                }
                                case 401: {
                                    switch (errorCode) {
                                        case -10012: {
                                            return new ExpiredTokenException(buffer.toString(), (Throwable)failure);
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                        break block35;
                    }
                    switch (failure.getCode()) {
                        case 500: {
                            break;
                        }
                        default: {
                            if (!json.has("debugInfo")) break;
                            log.warn((Object)String.format("Missing error code for failure %s", json));
                            if (!json.get("debugInfo").isJsonPrimitive()) break;
                            this.append(buffer, json.getAsJsonPrimitive("debugInfo").getAsString());
                            break;
                        }
                    }
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
        }
        switch (failure.getCode()) {
            case 412: {
                return new LoginFailureException(buffer.toString(), (Throwable)failure);
            }
        }
        return new HttpResponseExceptionMappingService().map((Throwable)failure, buffer, failure.getCode());
    }
}

