/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.model.StorageObject;

public class S3ObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3ObjectListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3AttributesFinderFeature attributes;

    public S3ObjectListService(S3Session session) {
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"));
    }

    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter, int chunksize) throws BackgroundException {
        try {
            String prefix = this.createPrefix(directory);
            Path bucket = this.containerService.getContainer(directory);
            AttributedList children = new AttributedList();
            String priorLastKey = null;
            do {
                String[] prefixes;
                Path file;
                PathAttributes attributes;
                StorageObject[] objects;
                StorageObjectsChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listObjectsChunked(PathNormalizer.name((String)URIEncoder.encode((String)bucket.getName())), prefix, delimiter, chunksize, priorLastKey);
                for (StorageObject object : objects = chunk.getObjects()) {
                    String key = PathNormalizer.normalize((String)object.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    EnumSet<AbstractPath.Type> types = object.getKey().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    attributes = this.attributes.toAttributes(object);
                    attributes.setRegion(bucket.attributes().getRegion());
                    file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), types, attributes) : new Path(directory, PathNormalizer.name((String)key), types, attributes);
                    children.add((Referenceable)file);
                }
                for (String common : prefixes = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common)) {
                        log.warn((Object)String.format("Skipping prefix %s", common));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)common);
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    attributes = new PathAttributes();
                    file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes) : new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                    attributes.setRegion(bucket.attributes().getRegion());
                    children.add((Referenceable)file);
                }
                priorLastKey = chunk.getPriorLastKey();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            return children;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
            prefix = prefix + '/';
        }
        return prefix;
    }
}

