/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.iam;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import org.apache.http.client.HttpResponseException;

public class AmazonServiceExceptionMappingService
extends AbstractExceptionMappingService<AmazonClientException> {
    public BackgroundException map(AmazonClientException e) {
        StringBuilder buffer = new StringBuilder();
        if (e instanceof AmazonServiceException) {
            AmazonServiceException failure = (AmazonServiceException)e;
            this.append(buffer, failure.getErrorMessage());
            switch (failure.getStatusCode()) {
                case 400: {
                    switch (failure.getErrorCode()) {
                        case "Throttling": {
                            return new RetriableAccessDeniedException(buffer.toString(), (Throwable)e);
                        }
                        case "AccessDeniedException": {
                            return new AccessDeniedException(buffer.toString(), (Throwable)e);
                        }
                        case "UnrecognizedClientException": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                    }
                }
                case 403: {
                    switch (failure.getErrorCode()) {
                        case "SignatureDoesNotMatch": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                        case "InvalidAccessKeyId": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                        case "InvalidClientTokenId": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                        case "InvalidSecurity": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                        case "MissingClientTokenId": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                        case "MissingAuthenticationToken": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                    }
                }
            }
            return new HttpResponseExceptionMappingService().map(new HttpResponseException(failure.getStatusCode(), buffer.toString()));
        }
        this.append(buffer, e.getMessage());
        return this.wrap((Throwable)e, buffer);
    }
}

