/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.RelocationResult;
import java.util.Collections;

public class DropboxMoveFeature
implements Move {
    private final DropboxSession session;
    private Delete delete;

    public DropboxMoveFeature(DropboxSession session) {
        this.session = session;
        this.delete = new DropboxDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            if (status.isExists()) {
                this.delete.delete(Collections.singletonList(renamed), (PasswordCallback)connectionCallback, callback);
            }
            RelocationResult result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).moveV2(file.getAbsolute(), renamed.getAbsolute());
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new DropboxAttributesFinderFeature(this.session).toAttributes(result.getMetadata()));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot move {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

