/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.core.DelimiterPathKindDetector;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathKindDetector;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProtocolFactory;
import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;

public class CommandLinePathParser {
    private final PathKindDetector detector = new DelimiterPathKindDetector();
    private final ProtocolFactory factory;

    public CommandLinePathParser(CommandLine input) {
        this(input, ProtocolFactory.get());
    }

    public CommandLinePathParser(CommandLine input, ProtocolFactory factory) {
        this.factory = factory;
    }

    public Path parse(String uri) {
        Host host = new HostParser(this.factory).get(uri);
        if (StringUtils.isBlank((CharSequence)host.getDefaultPath())) {
            return new Path(String.valueOf('/'), EnumSet.of(this.detector.detect(host.getDefaultPath())));
        }
        return new Path(PathNormalizer.normalize(host.getDefaultPath()), EnumSet.of(this.detector.detect(host.getDefaultPath())));
    }
}

