/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.spectralogic.ds3client.exceptions.Ds3NoMoreRetriesException;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.JobState;
import com.spectralogic.ds3client.helpers.events.FailureEvent;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.BlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransferStrategy
implements TransferStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransferStrategy.class);
    private final BlobStrategy blobStrategy;
    private final JobState jobState;
    private final ExecutorService executorService;
    private final EventDispatcher eventDispatcher;
    private final MasterObjectList masterObjectList;
    private final FailureEvent.FailureActivity failureActivity;
    private final AtomicReference<IOException> cachedException = new AtomicReference();
    private TransferMethod transferMethod;

    public AbstractTransferStrategy(BlobStrategy blobStrategy, JobState jobState, ExecutorService executorService, EventDispatcher eventDispatcher, MasterObjectList masterObjectList, FailureEvent.FailureActivity failureActivity) {
        this.blobStrategy = blobStrategy;
        this.jobState = jobState;
        this.executorService = executorService;
        this.eventDispatcher = eventDispatcher;
        this.masterObjectList = masterObjectList;
        this.failureActivity = failureActivity;
    }

    public AbstractTransferStrategy withTransferMethod(TransferMethod transferMethod) {
        this.transferMethod = transferMethod;
        return this;
    }

    @Override
    public void transfer() throws IOException {
        this.cachedException.set(null);
        try {
            this.transferAllJobBlobs();
        }
        finally {
            this.close();
        }
        if (this.cachedException.get() != null) {
            throw this.cachedException.get();
        }
    }

    private void transferAllJobBlobs() throws IOException {
        AtomicInteger numBlobsRemaining = new AtomicInteger(this.jobState.numBlobsInJob());
        while (!Thread.currentThread().isInterrupted() && numBlobsRemaining.get() > 0) {
            try {
                Iterable<JobPart> jobParts = this.jobPartsNotAlreadyTransferred();
                int numJobParts = Iterables.size(jobParts);
                if (numJobParts <= 0) break;
                CountDownLatch countDownLatch = new CountDownLatch(numJobParts);
                this.transferJobParts(jobParts, countDownLatch, numBlobsRemaining);
                countDownLatch.await();
            }
            catch (Ds3NoMoreRetriesException | FailedRequestException e) {
                this.emitFailureEvent(this.makeFailureEvent(this.failureActivity, e, this.firstChunk()));
                throw e;
            }
            catch (InterruptedException | NoSuchElementException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.emitFailureAndSetCachedException(t);
            }
        }
    }

    private Iterable<JobPart> jobPartsNotAlreadyTransferred() throws IOException, InterruptedException {
        return FluentIterable.from(this.blobStrategy.getWork()).filter(jobPart -> this.jobState.contains(jobPart.getBlob()));
    }

    private void emitFailureAndSetCachedException(Throwable t) {
        this.emitFailureEvent(this.makeFailureEvent(this.failureActivity, t, this.firstChunk()));
        this.maybeSetCachedException(t);
    }

    private synchronized void maybeSetCachedException(Throwable t) {
        if (this.cachedException.get() == null) {
            if (t instanceof IOException) {
                this.cachedException.set((IOException)t);
            } else {
                this.cachedException.set(new IOException(t));
            }
        }
    }

    private void transferJobParts(Iterable<JobPart> jobParts, CountDownLatch countDownLatch, AtomicInteger numBlobsTransferred) throws IOException {
        for (JobPart jobPart : jobParts) {
            this.executorService.execute(() -> {
                try {
                    this.transferMethod.transferJobPart(jobPart);
                }
                catch (RuntimeException e) {
                    this.emitFailureAndSetCachedException(e);
                    throw e;
                }
                catch (Exception e) {
                    this.emitFailureAndSetCachedException(e);
                    throw new RuntimeException(e);
                }
                finally {
                    this.jobState.blobTransferredOrFailed(jobPart.getBlob());
                    numBlobsTransferred.decrementAndGet();
                    countDownLatch.countDown();
                }
            });
        }
    }

    private void emitFailureEvent(FailureEvent failureEvent) {
        this.eventDispatcher.emitFailureEvent(failureEvent);
    }

    private FailureEvent makeFailureEvent(FailureEvent.FailureActivity failureActivity, Throwable causalException, Objects chunk) {
        return new FailureEvent.Builder().doingWhat(failureActivity).withCausalException(causalException).withObjectNamed(this.labelForChunk(chunk)).usingSystemWithEndpoint(this.masterObjectList.getNodes().get(0).getEndPoint()).build();
    }

    private String labelForChunk(Objects chunk) {
        try {
            return chunk.getObjects().get(0).getName();
        }
        catch (Throwable t) {
            LOG.error("Failed to get label for chunk.", t);
            return "unnamed object";
        }
    }

    private Objects firstChunk() {
        return this.masterObjectList.getObjects().get(0);
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }
}

