/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyUserSpectraS3Request
extends AbstractRequest {
    private final String userId;
    private String defaultDataPolicyId;
    private String name;
    private String secretKey;

    public ModifyUserSpectraS3Request(UUID userId) {
        this.userId = userId.toString();
    }

    public ModifyUserSpectraS3Request(String userId) {
        this.userId = userId;
    }

    public ModifyUserSpectraS3Request withDefaultDataPolicyId(UUID defaultDataPolicyId) {
        this.defaultDataPolicyId = defaultDataPolicyId.toString();
        this.updateQueryParam("default_data_policy_id", defaultDataPolicyId);
        return this;
    }

    public ModifyUserSpectraS3Request withDefaultDataPolicyId(String defaultDataPolicyId) {
        this.defaultDataPolicyId = defaultDataPolicyId;
        this.updateQueryParam("default_data_policy_id", defaultDataPolicyId);
        return this;
    }

    public ModifyUserSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public ModifyUserSpectraS3Request withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        this.updateQueryParam("secret_key", secretKey);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/user/" + this.userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDefaultDataPolicyId() {
        return this.defaultDataPolicyId;
    }

    public String getName() {
        return this.name;
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

