/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetStorageDomainSpectraS3Response;
import com.spectralogic.ds3client.models.StorageDomain;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetStorageDomainSpectraS3ResponseParser
extends AbstractResponseParser<GetStorageDomainSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetStorageDomainSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        StorageDomain result = XmlOutput.fromXml(inputStream, StorageDomain.class);
                        GetStorageDomainSpectraS3Response getStorageDomainSpectraS3Response = new GetStorageDomainSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getStorageDomainSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

