/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeleteWorker
extends Worker<List<Path>> {
    private static final Logger log = Logger.getLogger(DeleteWorker.class);
    private final List<Path> files;
    private final LoginCallback prompt;
    private final ProgressListener listener;
    private final Filter<Path> filter;

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener) {
        this(prompt, files, new NullFilter<Path>(), listener);
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, Filter<Path> filter, ProgressListener listener) {
        this.files = files;
        this.prompt = prompt;
        this.listener = listener;
        this.filter = filter;
    }

    @Override
    public List<Path> run(Session<?> session) throws BackgroundException {
        Delete delete = session.getFeature(Delete.class);
        ListService list = session.getFeature(ListService.class);
        ArrayList<Path> recursive = new ArrayList<Path>();
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            recursive.addAll(this.compile(delete, list, new WorkerListProgressListener(this, this.listener), file));
        }
        delete.delete(recursive, this.prompt, new Delete.Callback(){

            @Override
            public void delete(Path file) {
                DeleteWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
            }
        });
        return recursive;
    }

    protected Set<Path> compile(Delete delete, ListService list, ListProgressListener listener, Path file) throws BackgroundException {
        LinkedHashSet<Path> recursive = new LinkedHashSet<Path>();
        if (file.isFile() || file.isSymbolicLink()) {
            Path copy = new Path(file);
            if (!file.attributes().isDuplicate()) {
                log.debug((Object)String.format("Nullify version to add delete marker for %s", file));
                copy.attributes().setVersionId(null);
            }
            recursive.add(copy);
        } else if (file.isDirectory()) {
            if (!delete.isRecursive()) {
                for (Path child : list.list(file, listener).filter(this.filter)) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    if (child.attributes().isDuplicate() && child.isFile()) {
                        log.debug((Object)String.format("Skip duplicate %s", child));
                        continue;
                    }
                    Path copy = new Path(child);
                    copy.attributes().setVersionId(null);
                    recursive.addAll(this.compile(delete, list, listener, copy));
                }
            }
            recursive.add(file);
        }
        return recursive;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), this.toString(this.files));
    }

    @Override
    public List<Path> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteWorker)) {
            return false;
        }
        DeleteWorker that = (DeleteWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeleteWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

