/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Map;

public class VaultRegistryVersioningFeature
implements Versioning {
    private final Session<?> session;
    private final Versioning proxy;
    private final VaultRegistry registry;

    public VaultRegistryVersioningFeature(Session<?> session, Versioning proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Versioning withCache(Map<Path, VersioningConfiguration> cache) {
        this.proxy.withCache(cache);
        return this;
    }

    @Override
    public VersioningConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.registry.find(this.session, container).getFeature(this.session, Versioning.class, this.proxy).getConfiguration(container);
    }

    @Override
    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        this.registry.find(this.session, container).getFeature(this.session, Versioning.class, this.proxy).setConfiguration(container, prompt, configuration);
    }

    @Override
    public void revert(Path file) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Versioning.class, this.proxy).revert(file);
    }

    @Override
    public Credentials getToken(String mfaSerial, PasswordCallback callback) throws ConnectionCanceledException {
        return this.proxy.getToken(mfaSerial, callback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryVersioningFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

