/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;

public class BackgroundActionPauser {
    private static final Logger log = Logger.getLogger(BackgroundActionPauser.class);
    private Integer delay;
    private final Callback callback;

    public BackgroundActionPauser(Callback callback) {
        this(callback, PreferencesFactory.get().getInteger("connection.retry.delay"));
    }

    public BackgroundActionPauser(Callback callback, Integer delay) {
        this.callback = callback;
        this.delay = delay;
    }

    public void await() {
        if (0 == this.delay) {
            log.info((Object)"No pause between retry");
            return;
        }
        Timer wakeup = new Timer();
        CyclicBarrier wait = new CyclicBarrier(2);
        wakeup.scheduleAtFixedRate((TimerTask)new PauserTimerTask(wait), 0L, 1000L);
        try {
            wait.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static interface Callback
    extends StreamCancelation {
        @Override
        public boolean isCanceled();

        public void progress(Integer var1);
    }

    private final class PauserTimerTask
    extends TimerTask {
        private final CyclicBarrier wait;

        public PauserTimerTask(CyclicBarrier wait) {
            this.wait = wait;
        }

        @Override
        public void run() {
            if (0 == BackgroundActionPauser.this.delay || BackgroundActionPauser.this.callback.isCanceled()) {
                this.cancel();
                return;
            }
            Integer n = BackgroundActionPauser.this.delay;
            Integer n2 = BackgroundActionPauser.this.delay = BackgroundActionPauser.this.delay - 1;
            BackgroundActionPauser.this.callback.progress(n);
        }

        @Override
        public boolean cancel() {
            try {
                this.wait.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return super.cancel();
        }
    }
}

