/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.http.signature.ThreadLocalSigner;
import com.joyent.manta.client.MantaMBeanable;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import com.joyent.manta.exception.ConfigurationException;
import com.joyent.manta.http.HttpContextRetryCancellation;
import com.joyent.manta.http.InstrumentedPoolingHttpClientConnectionManager;
import com.joyent.manta.http.MantaConnectionFactoryConfigurator;
import com.joyent.manta.http.MantaHttpRequestExecutor;
import com.joyent.manta.http.MantaHttpRequestRetryHandler;
import com.joyent.manta.http.MantaSSLConnectionSocketFactory;
import com.joyent.manta.http.MantaServiceUnavailableRetryStrategy;
import com.joyent.manta.http.PoolStatsMBean;
import com.joyent.manta.http.RetryConfigAware;
import com.joyent.manta.http.ShufflingDnsResolver;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyPair;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.DynamicMBean;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaConnectionFactory
implements Closeable,
MantaMBeanable,
RetryConfigAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaConnectionFactory.class);
    private static final DnsResolver DNS_RESOLVER = new ShufflingDnsResolver();
    private static final String USER_AGENT = String.format("Java-Manta-SDK/%s (Java/%s/%s)", "3.2.3", System.getProperty("java.version"), System.getProperty("java.vendor"));
    private final ConfigContext config;
    private final HttpClientBuilder httpClientBuilder;
    private final HttpClientConnectionManager connectionManager;
    private final HttpRequestRetryHandler retryHandler;
    private final ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;

    @Deprecated
    public MantaConnectionFactory(ConfigContext config, KeyPair keyPair, ThreadLocalSigner signer) {
        this(config, null);
    }

    @Deprecated
    public MantaConnectionFactory(ConfigContext config, KeyPair keyPair, ThreadLocalSigner signer, MantaConnectionFactoryConfigurator connectionFactoryConfigurator) {
        this(config, connectionFactoryConfigurator);
    }

    public MantaConnectionFactory(ConfigContext config) {
        this(config, null);
    }

    public MantaConnectionFactory(ConfigContext config, MantaConnectionFactoryConfigurator connectionFactoryConfigurator) {
        this(config, connectionFactoryConfigurator, null);
    }

    public MantaConnectionFactory(ConfigContext config, MantaConnectionFactoryConfigurator connectionFactoryConfigurator, MantaClientMetricConfiguration metricConfig) {
        this.config = (ConfigContext)Validate.notNull((Object)config, (String)"Configuration context must not be null", (Object[])new Object[0]);
        if (connectionFactoryConfigurator != null) {
            this.connectionManager = null;
            this.httpClientBuilder = connectionFactoryConfigurator.getHttpClientBuilder();
        } else {
            this.connectionManager = this.buildConnectionManager(metricConfig);
            this.httpClientBuilder = this.createStandardBuilder(metricConfig);
        }
        this.httpClientBuilder.disableRedirectHandling();
        if (config.getRetries() > 0) {
            this.retryHandler = new MantaHttpRequestRetryHandler(config.getRetries(), metricConfig);
            this.serviceUnavailableRetryStrategy = new MantaServiceUnavailableRetryStrategy(config.getRetries());
            this.httpClientBuilder.setRetryHandler(this.retryHandler);
            this.httpClientBuilder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        } else {
            LOGGER.info("Retry of failed requests is disabled");
            this.retryHandler = null;
            this.serviceUnavailableRetryStrategy = null;
            this.httpClientBuilder.disableAutomaticRetries();
        }
        if (this.connectionManager != null) {
            this.httpClientBuilder.setConnectionManager(this.connectionManager);
        }
    }

    protected HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> buildHttpConnectionFactory() {
        return new ManagedHttpClientConnectionFactory((HttpMessageWriterFactory)new DefaultHttpRequestWriterFactory(), (HttpMessageParserFactory)new DefaultHttpResponseParserFactory());
    }

    protected SocketConfig buildSocketConfig() {
        int socketTimeout = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getTcpSocketTimeout(), 10000});
        return SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).setSoKeepAlive(true).build();
    }

    protected ConnectionConfig buildConnectionConfig() {
        int bufferSize = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getHttpBufferSize(), 4096});
        return ConnectionConfig.custom().setBufferSize(bufferSize).build();
    }

    protected HttpClientConnectionManager buildConnectionManager(MantaClientMetricConfiguration metricConfig) {
        int maxConns = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getMaximumConnections(), 24});
        MantaSSLConnectionSocketFactory sslConnectionSocketFactory = new MantaSSLConnectionSocketFactory(this.config);
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        Registry socketFactoryRegistry = registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory = this.buildHttpConnectionFactory();
        PoolingHttpClientConnectionManager connManager = metricConfig != null ? new InstrumentedPoolingHttpClientConnectionManager(metricConfig.getRegistry(), (Registry<ConnectionSocketFactory>)socketFactoryRegistry, connFactory, null, DNS_RESOLVER, -1L, TimeUnit.MILLISECONDS) : new PoolingHttpClientConnectionManager(socketFactoryRegistry, connFactory, DNS_RESOLVER);
        connManager.setDefaultMaxPerRoute(maxConns);
        connManager.setMaxTotal(maxConns);
        connManager.setDefaultSocketConfig(this.buildSocketConfig());
        connManager.setDefaultConnectionConfig(this.buildConnectionConfig());
        return connManager;
    }

    protected HttpClientBuilder createStandardBuilder(MantaClientMetricConfiguration metricConfig) {
        int maxConns = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getMaximumConnections(), 24});
        int timeout = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getTimeout(), 20000});
        int connectionRequestTimeout = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.config.getConnectionRequestTimeout(), 1000});
        Integer expectContinueTimeout = this.config.getExpectContinueTimeout();
        boolean expectContinueEnabled = expectContinueTimeout != null;
        RequestConfig requestConfig = RequestConfig.custom().setAuthenticationEnabled(false).setSocketTimeout(timeout).setConnectionRequestTimeout(connectionRequestTimeout).setContentCompressionEnabled(true).setExpectContinueEnabled(expectContinueEnabled).build();
        MantaHttpRequestExecutor requestExecutor = MantaHttpRequestExecutor.Builder.create().setMetricConfiguration(metricConfig).setWaitForContinue(expectContinueTimeout).build();
        HttpClientBuilder builder = HttpClients.custom().disableAuthCaching().disableCookieManagement().setUserAgent(USER_AGENT).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setMaxConnTotal(maxConns).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).setDefaultRequestConfig(requestConfig).setConnectionManagerShared(false).setRequestExecutor((HttpRequestExecutor)requestExecutor).setConnectionBackoffStrategy((ConnectionBackoffStrategy)new DefaultBackoffStrategy());
        HttpHost proxyHost = this.findProxyServer();
        if (proxyHost != null) {
            builder.setProxy(proxyHost);
        }
        return builder;
    }

    protected HttpHost findProxyServer() {
        ProxySelector proxySelector = ProxySelector.getDefault();
        List<Proxy> proxies = proxySelector.select(URI.create(this.config.getMantaURL()));
        if (!proxies.isEmpty()) {
            Proxy proxy = proxies.get(0);
            switch (proxy.type()) {
                case DIRECT: {
                    return null;
                }
                case SOCKS: {
                    throw new ConfigurationException("SOCKS proxies are unsupported");
                }
            }
            if (proxy.address() instanceof InetSocketAddress) {
                InetSocketAddress sa = (InetSocketAddress)proxy.address();
                return new HttpHost(sa.getHostName(), sa.getPort());
            }
            String msg = String.format("Expecting proxy to be instance of InetSocketAddress.  Actually: %s", proxy.address());
            throw new ConfigurationException(msg);
        }
        return null;
    }

    public CloseableHttpClient createConnection() {
        return this.httpClientBuilder.build();
    }

    @Override
    public DynamicMBean toMBean() {
        if (!(this.connectionManager instanceof PoolingHttpClientConnectionManager)) {
            return null;
        }
        return new PoolStatsMBean((PoolingHttpClientConnectionManager)this.connectionManager);
    }

    @Override
    public boolean isRetryEnabled() {
        return ObjectUtils.allNotNull((Object[])new Object[]{this.retryHandler, this.serviceUnavailableRetryStrategy});
    }

    @Override
    public boolean isRetryCancellable() {
        return this.retryHandler instanceof HttpContextRetryCancellation && this.serviceUnavailableRetryStrategy instanceof HttpContextRetryCancellation;
    }

    @Override
    public void close() throws IOException {
        if (this.connectionManager == null) {
            return;
        }
        this.connectionManager.shutdown();
    }
}

