/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.codahale.metrics.MetricRegistry;
import com.joyent.manta.client.MantaMBeanable;
import com.joyent.manta.client.MetricReporterSupplier;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MantaClientAgent
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaClientAgent.class);
    static final String FMT_MBEAN_OBJECT_NAME = "com.joyent.manta.client:00=%s,type=%s";
    private final MantaClientMetricConfiguration metricConfig;
    private final Map<ObjectName, DynamicMBean> beans;
    private final Closeable metricReporter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    MantaClientAgent() {
        this(new MantaClientMetricConfiguration(UUID.randomUUID(), new MetricRegistry()));
    }

    MantaClientAgent(MantaClientMetricConfiguration metricConfig) {
        this.metricConfig = metricConfig;
        this.beans = new HashMap<ObjectName, DynamicMBean>(2);
        this.metricReporter = metricConfig.getRegistry() != null && metricConfig.getReporterMode() != null ? new MetricReporterSupplier(metricConfig).get() : null;
    }

    void register(MantaMBeanable beanable) {
        ObjectName name;
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot register MBeans, agent has been closed");
        }
        DynamicMBean bean = beanable.toMBean();
        if (bean == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("MantaMBeanable object returned null");
            }
            return;
        }
        try {
            name = new ObjectName(String.format(FMT_MBEAN_OBJECT_NAME, bean.getClass().getSimpleName(), this.metricConfig.getClientId()));
        }
        catch (JMException e) {
            LOGGER.warn("Error creating bean: " + bean.getClass().getSimpleName(), (Throwable)e);
            return;
        }
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(bean, name);
            this.beans.put(name, bean);
        }
        catch (JMException e) {
            LOGGER.warn(String.format("Error registering [%s] MBean in JMX", name), (Throwable)e);
        }
    }

    void reset() throws Exception {
        if (!this.beans.isEmpty()) {
            this.close();
        }
        this.closed.set(false);
    }

    Map<ObjectName, DynamicMBean> getBeans() {
        return Collections.unmodifiableMap(this.beans);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (Map.Entry<ObjectName, DynamicMBean> bean : this.beans.entrySet()) {
            try {
                server.unregisterMBean(bean.getKey());
            }
            catch (JMException e) {
                LOGGER.warn(String.format("Error deregistering [%s] MBean in JMX", bean.getKey()), (Throwable)e);
            }
        }
        if (this.metricReporter != null) {
            this.metricReporter.close();
        }
        this.beans.clear();
    }
}

