/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.AuthenticationResponse;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;

public class AuthenticationJson11ResponseHandler
implements ResponseHandler<AuthenticationResponse> {
    public AuthenticationResponse handleResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            Charset charset = HTTP.DEF_CONTENT_CHARSET;
            ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
            if (contentType != null && contentType.getCharset() != null) {
                charset = contentType.getCharset();
            }
            try {
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse((Reader)new InputStreamReader(response.getEntity().getContent(), charset)).getAsJsonObject();
                JsonObject auth = json.getAsJsonObject("auth");
                String token = auth.getAsJsonObject("token").get("id").getAsString();
                HashMap<String, String> cdnUrls = new HashMap<String, String>();
                JsonObject serviceCatalog = auth.getAsJsonObject("serviceCatalog");
                for (JsonElement e : serviceCatalog.getAsJsonArray("cloudFilesCDN")) {
                    JsonObject cloudFilesCDN = e.getAsJsonObject();
                    String regionId = cloudFilesCDN.get("region").getAsString();
                    String publicUrl = cloudFilesCDN.get("publicURL").getAsString();
                    cdnUrls.put(regionId, publicUrl);
                }
                HashSet<Region> regions = new HashSet<Region>();
                for (JsonElement e : serviceCatalog.getAsJsonArray("cloudFiles")) {
                    JsonObject cloudFiles = e.getAsJsonObject();
                    String regionId = cloudFiles.get("region").getAsString();
                    String publicUrl = cloudFiles.get("publicURL").getAsString();
                    String cdnUrl = cdnUrls.containsKey(regionId) ? (String)cdnUrls.get(regionId) : null;
                    Boolean v1Default = cloudFiles.get("v1Default") != null ? cloudFiles.get("v1Default").getAsBoolean() : Boolean.FALSE.booleanValue();
                    regions.add(new Region(regionId, URI.create(publicUrl), cdnUrl == null ? null : URI.create(cdnUrl), v1Default));
                }
                return new AuthenticationResponse(response, token, regions);
            }
            catch (JsonParseException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

