/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.Signer;
import com.joyent.http.signature.ThreadLocalSigner;
import com.joyent.http.signature.apache.httpclient.HttpSignatureCache;
import java.security.KeyPair;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class HttpSignatureAuthScheme
implements ContextAwareAuthScheme {
    public static final String SCHEME_NAME = "Signatures";
    private static final Log LOG = LogFactory.getLog(HttpSignatureAuthScheme.class);
    private static final Function<Credentials, HttpSignatureCache> NEW_CACHE_FUNCTION = HttpSignatureCache::new;
    private final KeyPair keyPair;
    private final ThreadLocalSigner signer;
    private ConcurrentMap<Credentials, HttpSignatureCache> signatureCacheMap = new ConcurrentHashMap<Credentials, HttpSignatureCache>();

    public HttpSignatureAuthScheme(KeyPair keyPair) {
        this(keyPair, true);
    }

    @Deprecated
    public HttpSignatureAuthScheme(KeyPair keyPair, boolean useNativeCodeToSign) {
        this(keyPair, new ThreadLocalSigner());
    }

    public HttpSignatureAuthScheme(KeyPair keyPair, ThreadLocalSigner signer) {
        if (keyPair == null) {
            throw new IllegalArgumentException("KeyPair must be present");
        }
        this.keyPair = keyPair;
        this.signer = signer;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        throw new IllegalStateException("No challenge should ever occur");
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public String getParameter(String name) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.signRequestHeader(credentials, request);
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    public String toString() {
        return this.getSchemeName().toUpperCase(Locale.ROOT);
    }

    protected Header signRequestHeader(Credentials credentials, HttpRequest request) throws AuthenticationException {
        String stringDate;
        Header date;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Signing request: %s", request));
        }
        if ((date = request.getFirstHeader("Date")) != null) {
            stringDate = date.getValue();
        } else {
            stringDate = ((Signer)this.signer.get()).defaultSignDateAsString();
            request.setHeader("Date", stringDate);
        }
        this.signatureCacheMap.computeIfAbsent(credentials, NEW_CACHE_FUNCTION);
        String authz = ((HttpSignatureCache)this.signatureCacheMap.get(credentials)).updateAndGetSignature(stringDate, (Signer)this.signer.get(), this.keyPair);
        return new BasicHeader("Authorization", authz);
    }

    public ThreadLocalSigner getSigner() {
        return this.signer;
    }
}

