/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Vault;
import java.util.Set;

public class CryptoEncryptionFeature
implements Encryption {
    private final Session<?> session;
    private final Encryption delegate;
    private final Vault vault;

    public CryptoEncryptionFeature(Session<?> session, Encryption delegate, CryptoVault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        return this.delegate.getEncryption(this.vault.encrypt(this.session, file));
    }

    public void setEncryption(Path file, Encryption.Algorithm algorithm) throws BackgroundException {
        this.delegate.setEncryption(this.vault.encrypt(this.session, file), algorithm);
    }

    public Encryption.Algorithm getDefault(Path file) throws BackgroundException {
        return this.delegate.getDefault(this.vault.encrypt(this.session, file));
    }

    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        return this.delegate.getKeys(this.vault.encrypt(this.session, file), prompt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoEncryptionFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

