/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.cryptomator.CryptoAuthenticationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoInputStream
extends ProxyInputStream {
    private final InputStream proxy;
    private final Cryptor cryptor;
    private final FileHeader header;
    private ByteBuffer buffer = ByteBuffer.allocate(0);
    private long chunkIndexOffset;
    private final int chunkSize;

    public CryptoInputStream(InputStream proxy, Cryptor cryptor, FileHeader header, long chunkIndexOffset) throws IOException {
        super(proxy);
        this.proxy = proxy;
        this.cryptor = cryptor;
        this.header = header;
        this.chunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        this.chunkIndexOffset = chunkIndexOffset;
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.readNextChunk();
        }
        return this.buffer.get();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] dst, int off, int len) throws IOException {
        int read;
        if (!this.buffer.hasRemaining() && (read = this.readNextChunk()) == -1) {
            return -1;
        }
        read = Math.min(len, this.buffer.remaining());
        this.buffer.get(dst, off, read);
        return read;
    }

    public long skip(long len) throws IOException {
        return IOUtils.skip((InputStream)((Object)this), (long)len);
    }

    private int readNextChunk() throws IOException {
        ByteBuffer ciphertextBuf = ByteBuffer.allocate(this.chunkSize);
        int read = IOUtils.read((InputStream)this.proxy, (byte[])ciphertextBuf.array());
        if (read == 0) {
            return -1;
        }
        ciphertextBuf.position(read);
        ciphertextBuf.flip();
        try {
            this.buffer = this.cryptor.fileContentCryptor().decryptChunk(ciphertextBuf, this.chunkIndexOffset++, this.header, true);
        }
        catch (CryptoException e) {
            throw new IOException(e.getMessage(), (Throwable)((Object)new CryptoAuthenticationException(e.getMessage(), e)));
        }
        return read;
    }
}

