/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.OneDriveDeleteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;

public class OneDriveMoveFeature
implements Move {
    private final OneDriveSession session;
    private Delete delete;
    private final PathContainerService containerService = new PathContainerService();

    public OneDriveMoveFeature(OneDriveSession session) {
        this.session = session;
        this.delete = new OneDriveDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (status.isExists()) {
            this.delete.delete(Collections.singletonList(renamed), (PasswordCallback)connectionCallback, callback);
        }
        OneDrivePatchOperation patchOperation = new OneDrivePatchOperation();
        if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
            patchOperation.rename(renamed.getName());
        }
        if (!file.getParent().equals((Object)renamed.getParent())) {
            OneDriveFolder moveTarget = this.session.toFolder(renamed.getParent());
            patchOperation.move(moveTarget);
        }
        OneDriveItem item = this.session.toItem(file);
        try {
            item.patch(patchOperation);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot rename {0}", (Throwable)e, file);
        }
        return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new OneDriveAttributesFinderFeature(this.session).find(renamed));
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source)) {
            return false;
        }
        if (!this.containerService.getContainer(source).equals((Object)this.containerService.getContainer(target))) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.shared);
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

