/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveAttributesFinderFeature;

public class OneDriveFindFeature
implements Find {
    private final OneDriveSession session;

    public OneDriveFindFeature(OneDriveSession session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            new OneDriveAttributesFinderFeature(this.session).find(file);
            return true;
        }
        catch (InteroperabilityException | NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        return this;
    }
}

