/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;

public abstract class GraphSession
extends HttpSession<OneDriveAPI> {
    protected GraphSession(Host host, ThreadLocalHostnameDelegatingTrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public OneDriveItem toItem(Path currentPath) throws BackgroundException {
        return this.toItem(currentPath, true);
    }

    public abstract OneDriveItem toItem(Path var1, boolean var2) throws BackgroundException;

    public OneDriveFile toFile(Path currentPath) throws BackgroundException {
        return this.toFile(currentPath, true);
    }

    public OneDriveFile toFile(Path currentPath, boolean resolveLastItem) throws BackgroundException {
        OneDriveItem item = this.toItem(currentPath, resolveLastItem);
        if (!(item instanceof OneDriveFile)) {
            throw new NotfoundException(String.format("%s is not a file.", currentPath.getAbsolute()));
        }
        return (OneDriveFile)item;
    }

    public OneDriveFolder toFolder(Path currentPath) throws BackgroundException {
        return this.toFolder(currentPath, true);
    }

    public OneDriveFolder toFolder(Path currentPath, boolean resolveLastItem) throws BackgroundException {
        OneDriveItem item = this.toItem(currentPath, resolveLastItem);
        if (!(item instanceof OneDriveFolder)) {
            throw new NotfoundException(String.format("%s is not a folder.", currentPath.getAbsolute()));
        }
        return (OneDriveFolder)item;
    }
}

