/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.rule.IRODSRule;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.irods.jargon.core.rule.JargonRuleException;
import org.irods.jargon.core.rule.RuleCharacteristics;
import org.irods.jargon.core.rule.RuleInputParameter;
import org.irods.jargon.core.rule.RuleParsingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSRuleTranslator {
    private static final String SPLAT = "*";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final IRODSServerProperties irodsServerProperties;

    public IRODSRuleTranslator(IRODSServerProperties irodsServerProperties) {
        if (irodsServerProperties == null) {
            throw new IllegalArgumentException("null irodsServerProperties");
        }
        this.irodsServerProperties = irodsServerProperties;
    }

    public IRODSRule translatePlainTextRuleIntoIRODSRule(String ruleAsPlainText) throws JargonRuleException, JargonException {
        return this.translatePlainTextRuleIntoIRODSRule(ruleAsPlainText, null);
    }

    public IRODSRule translatePlainTextRuleIntoIRODSRule(String ruleAsPlainText, List<IRODSRuleParameter> overrideInputParameters) throws JargonRuleException, JargonException {
        IRODSRule irodsRule;
        List<Object> inputParameters;
        if (ruleAsPlainText == null || ruleAsPlainText.isEmpty()) {
            throw new IllegalArgumentException("null or empty rule text");
        }
        this.log.info("translating rule: {}", (Object)ruleAsPlainText);
        String trimmedRule = ruleAsPlainText.trim();
        boolean newFormatRule = IRODSRuleTranslator.isUsingNewRuleSyntax(trimmedRule);
        StringTokenizer tokens = new StringTokenizer(trimmedRule, "\n");
        ArrayList<String> tokenLines = new ArrayList<String>();
        while (tokens.hasMoreElements()) {
            String token = (String)tokens.nextElement();
            if (token.trim().isEmpty()) continue;
            tokenLines.add(token);
        }
        if (newFormatRule) {
            this.log.info("parsing in new format");
            RuleCharacteristics ruleCharacteristics = IRODSRuleTranslator.processRuleBodyNewFormat(tokenLines);
            if (ruleCharacteristics == null) {
                throw new JargonRuleException("unable to parse rule");
            }
            inputParameters = ruleCharacteristics.getInputLineIndex() != -1 ? this.processRuleInputAttributesLine((String)tokenLines.get(ruleCharacteristics.getInputLineIndex())) : new ArrayList();
            if (overrideInputParameters != null) {
                this.log.info("will override parameters");
                inputParameters = this.collateOverridesIntoInputParameters(overrideInputParameters, inputParameters);
            }
            List<IRODSRuleParameter> outputParameters = ruleCharacteristics.getInputLineIndex() != -1 ? this.processRuleOutputAttributesLine((String)tokenLines.get(ruleCharacteristics.getOutputLineIndex())) : new ArrayList<IRODSRuleParameter>();
            irodsRule = IRODSRule.instance(ruleAsPlainText, inputParameters, outputParameters, ruleCharacteristics.getRuleBody());
        } else {
            this.log.info("parsing in old format");
            if (tokenLines.size() < 3) {
                this.log.error("unable to find the required lines (rule body, input parameters, output parameters) in rule body:{}", (Object)trimmedRule);
                throw new JargonRuleException("Rule requires at least 3 lines for body, input, and output parameters");
            }
            inputParameters = this.processRuleInputAttributesLine((String)tokenLines.get(tokenLines.size() - 2));
            if (overrideInputParameters != null) {
                this.log.info("will override parameters");
                inputParameters = this.collateOverridesIntoInputParameters(overrideInputParameters, inputParameters);
            }
            List<IRODSRuleParameter> outputParameters = this.processRuleOutputAttributesLine((String)tokenLines.get(tokenLines.size() - 1));
            irodsRule = IRODSRule.instance(ruleAsPlainText, inputParameters, outputParameters, IRODSRuleTranslator.processRuleBodyOldFormat(tokenLines));
        }
        return irodsRule;
    }

    protected List<IRODSRuleParameter> collateOverridesIntoInputParameters(List<IRODSRuleParameter> overrideInputParameters, List<IRODSRuleParameter> inputParameters) {
        boolean found;
        if (overrideInputParameters == null) {
            throw new IllegalArgumentException("null overrideInputParameters");
        }
        if (inputParameters == null) {
            throw new IllegalArgumentException("null inputParameters");
        }
        ArrayList<IRODSRuleParameter> overriddenParms = new ArrayList<IRODSRuleParameter>();
        for (IRODSRuleParameter current : inputParameters) {
            found = false;
            for (IRODSRuleParameter override : overrideInputParameters) {
                if (!current.getUniqueName().equals(override.getUniqueName())) continue;
                overriddenParms.add(override);
                found = true;
            }
            if (found) continue;
            overriddenParms.add(current);
        }
        for (IRODSRuleParameter override : overrideInputParameters) {
            found = false;
            for (IRODSRuleParameter current : overriddenParms) {
                if (!current.getUniqueName().equals(override.getUniqueName())) continue;
                found = true;
            }
            if (!found) {
                overriddenParms.add(override);
            }
            this.log.info("replacing original parms with overridden parms:{}", overriddenParms);
            inputParameters = overriddenParms;
        }
        return inputParameters;
    }

    static RuleCharacteristics processRuleBodyNewFormat(List<String> tokenLines) {
        if (tokenLines.size() == 0) {
            return null;
        }
        int tokenInput = -1;
        int tokenOutput = -1;
        int lastRowOfRule = tokenLines.size();
        for (int i = tokenLines.size() - 1; i >= 0; --i) {
            if (tokenLines.get(i).toUpperCase().startsWith("OUTPUT")) {
                tokenOutput = i;
                continue;
            }
            if (tokenLines.get(i).toUpperCase().startsWith("INPUT")) {
                tokenInput = i;
                continue;
            }
            lastRowOfRule = i;
            break;
        }
        StringBuilder total = new StringBuilder();
        for (int i = 0; i <= lastRowOfRule; ++i) {
            total.append(tokenLines.get(i));
            total.append("\n");
        }
        RuleCharacteristics ruleCharacteristics = new RuleCharacteristics();
        ruleCharacteristics.setInputLineIndex(tokenInput);
        ruleCharacteristics.setOutputLineIndex(tokenOutput);
        ruleCharacteristics.setLastLineOfBody(lastRowOfRule);
        ruleCharacteristics.setRuleBody(total.toString());
        return ruleCharacteristics;
    }

    static String processRuleBodyOldFormat(List<String> tokenLines) {
        StringBuilder total = new StringBuilder();
        int ctr = 0;
        for (String line : tokenLines) {
            if (ctr == tokenLines.size() - 2) break;
            total.append(line);
            total.append("\n");
            ++ctr;
        }
        return total.toString();
    }

    List<IRODSRuleParameter> processRuleOutputAttributesLine(String outputAttributesLine) throws JargonRuleException, JargonException {
        if (outputAttributesLine == null) {
            throw new JargonRuleException("null passed to output attributes parser");
        }
        if ((outputAttributesLine = outputAttributesLine.trim()).isEmpty()) {
            throw new JargonRuleException("outputAttributes line is blank");
        }
        int idxInput = outputAttributesLine.indexOf("OUTPUT");
        if (idxInput > -1) {
            outputAttributesLine = outputAttributesLine.substring(idxInput + 6);
        }
        if (outputAttributesLine.indexOf("**") > -1) {
            throw new JargonRuleException("blank attribute in output attributes line indicated by duplicate '*' delimiters with no data");
        }
        if (outputAttributesLine.indexOf("%%") > -1) {
            throw new JargonRuleException("blank attribute in output attributes line indicated by duplicate '%' delimiters with no data");
        }
        ArrayList<IRODSRuleParameter> outputAttributes = new ArrayList<IRODSRuleParameter>();
        StringTokenizer outputParmsTokenizer = null;
        outputParmsTokenizer = new StringTokenizer(outputAttributesLine.replaceAll(",", "%"), "%");
        while (outputParmsTokenizer.hasMoreTokens()) {
            outputAttributes.add(this.processOutputParmsToken(outputParmsTokenizer.nextToken().trim()));
        }
        return outputAttributes;
    }

    private IRODSRuleParameter processOutputParmsToken(String nextToken) throws JargonException, JargonRuleException {
        if (nextToken == null) {
            throw new JargonException("null nextToken");
        }
        if (nextToken.isEmpty()) {
            throw new JargonRuleException("output parms token is empty");
        }
        String parmName = nextToken;
        this.log.debug("returning outputParm: {}", (Object)parmName);
        return new IRODSRuleParameter(parmName, "");
    }

    List<IRODSRuleParameter> processRuleInputAttributesLine(String inputAttributesLine) throws JargonRuleException, JargonException {
        if (inputAttributesLine == null) {
            throw new JargonRuleException("null tokens passed to input attributes parser");
        }
        if ((inputAttributesLine = inputAttributesLine.trim()).isEmpty()) {
            throw new JargonRuleException("inputAttributesLine is empty");
        }
        int idxInput = inputAttributesLine.indexOf("INPUT");
        if (idxInput > -1) {
            inputAttributesLine = inputAttributesLine.substring(idxInput + 5).trim();
        }
        ArrayList<IRODSRuleParameter> inputAttributes = new ArrayList<IRODSRuleParameter>();
        if (inputAttributesLine.equals("null")) {
            if (this.irodsServerProperties.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0") && idxInput > -1) {
                this.log.info("no null prop for new format irods rules");
            } else {
                this.log.info("adding null param for old style rule");
                inputAttributes.add(new IRODSRuleParameter());
            }
            return inputAttributes;
        }
        if (inputAttributesLine.indexOf("%%") > -1) {
            throw new JargonRuleException("blank attribute in input attributes line indicated by duplicate '%' delimiters with no data");
        }
        StringTokenizer inputParmsTokenizer = null;
        inputParmsTokenizer = idxInput > -1 ? new StringTokenizer(inputAttributesLine, ",") : new StringTokenizer(inputAttributesLine, "%");
        while (inputParmsTokenizer.hasMoreTokens()) {
            IRODSRuleParameter param = this.processInputParmsToken(inputParmsTokenizer.nextToken());
            if (param == null) continue;
            inputAttributes.add(param);
        }
        return inputAttributes;
    }

    private IRODSRuleParameter processInputParmsToken(String nextToken) throws JargonRuleException, JargonException {
        if (nextToken == null) {
            throw new JargonException("null nextToken");
        }
        if (nextToken.isEmpty()) {
            throw new JargonRuleException("input parms token is empty");
        }
        if ((nextToken = nextToken.trim()).equals("null")) {
            throw new JargonRuleException("embedded 'null' in input attributes, must be the only value if null");
        }
        RuleInputParameter param = RuleParsingUtils.parseInputParameterForNameAndValue(nextToken);
        if (param == null) {
            return null;
        }
        if (param.getParamName().indexOf(SPLAT) == -1) {
            throw new JargonRuleException("missing * in first character of input parameter:" + param.getParamName());
        }
        if (param.getParamName().indexOf(SPLAT) > 0) {
            throw new JargonRuleException("* must be the first character of input parameter:" + param.getParamName());
        }
        if (param.getParamName().indexOf(SPLAT, 1) > -1) {
            throw new JargonRuleException("duplicate '*' character in parm:" + param.getParamName());
        }
        this.log.debug("returning inputParm: {}", (Object)param);
        return new IRODSRuleParameter(param.getParamName(), param.getParamValue());
    }

    public static final boolean isUsingNewRuleSyntax(String ruleText) {
        if (ruleText == null || ruleText.isEmpty()) {
            throw new IllegalArgumentException("null or empty ruleText");
        }
        boolean isNew = false;
        if (ruleText.indexOf(124) == -1 && ruleText.indexOf(123) > -1) {
            isNew = true;
        }
        return isNew;
    }
}

