/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.SimpleQueryInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.SimpleQueryExecutorAO;
import org.irods.jargon.core.query.AbstractAliasedQuery;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.IRODSSimpleQueryResultSet;
import org.irods.jargon.core.query.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryExecutorAOImpl
extends IRODSGenericAO
implements SimpleQueryExecutorAO {
    private static final Logger log = LoggerFactory.getLogger(SimpleQueryExecutorAOImpl.class);
    public static final String OUT_BUF = "outBuf";

    protected SimpleQueryExecutorAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSQueryResultSetInterface executeSimpleQuery(AbstractAliasedQuery simpleQuery) throws JargonException {
        if (simpleQuery == null) {
            throw new IllegalArgumentException("null simpleQuery");
        }
        log.info("executeSimpleQuery:{}", (Object)simpleQuery);
        Tag response = this.getResponse((SimpleQuery)simpleQuery);
        if (response == null) {
            log.info("response from IRODS call indicates no rows found");
            IRODSSimpleQueryResultSet resultSet = IRODSSimpleQueryResultSet.instance(simpleQuery, new ArrayList<IRODSQueryResultRow>(), new ArrayList<String>(), false);
            return resultSet;
        }
        List<String> rows = this.extractRows(response);
        List<String> colNames = this.parseColumnNames(rows);
        List<IRODSQueryResultRow> result = this.generateResultRows(rows, colNames);
        IRODSSimpleQueryResultSet resultSet = IRODSSimpleQueryResultSet.instance(simpleQuery, result, colNames, true);
        return resultSet;
    }

    private Tag getResponse(SimpleQuery simpleQuery) throws JargonException {
        SimpleQueryInp simpleQueryInp = SimpleQueryInp.instance(simpleQuery);
        Tag response = null;
        try {
            response = this.getIRODSProtocol().irodsFunction(simpleQueryInp);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found");
        }
        return response;
    }

    private List<String> extractRows(Tag response) {
        String rawResponse = response.getTag(OUT_BUF).getStringValue();
        List<String> rows = Arrays.asList(rawResponse.split("\n"));
        return rows;
    }

    private ArrayList<ArrayList<String>> divideRows(List<String> rows) {
        ArrayList<ArrayList<String>> outerList = new ArrayList<ArrayList<String>>();
        ArrayList<String> innerList = new ArrayList<String>();
        for (String r : rows) {
            if (!r.trim().isEmpty()) {
                innerList.add(r);
                continue;
            }
            outerList.add(innerList);
            innerList = new ArrayList();
        }
        outerList.add(innerList);
        return outerList;
    }

    private IRODSQueryResultRow convertRowToResultRow(List<String> rowList, List<String> columnNames) throws JargonException {
        int delimiter = 58;
        ArrayList<String> columnValues = new ArrayList<String>();
        for (String row : rowList) {
            columnValues.add(row.substring(row.indexOf(delimiter) + 1).trim());
        }
        return IRODSQueryResultRow.instance(columnValues, columnNames);
    }

    private List<IRODSQueryResultRow> generateResultRows(List<String> rows, List<String> columnNames) throws JargonException {
        ArrayList<IRODSQueryResultRow> results = new ArrayList<IRODSQueryResultRow>();
        for (List list : this.divideRows(rows)) {
            results.add(this.convertRowToResultRow(list, columnNames));
        }
        return results;
    }

    private List<String> parseColumnNames(List<String> rows) {
        ArrayList<String> colNames = new ArrayList<String>();
        if (rows.size() > 0) {
            int idx = rows.get(0).indexOf(58);
            String firstColName = rows.get(0).substring(0, idx);
            colNames.add(firstColName.trim());
            for (int i = 1; i < rows.size(); ++i) {
                idx = rows.get(i).indexOf(58);
                String thisCol = rows.get(i).substring(0, idx).trim();
                if (thisCol.equals(firstColName)) break;
                colNames.add(thisCol.trim());
            }
        }
        return colNames;
    }
}

