/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.domain.SpecificQueryDefinition;

public class GeneralAdminInpForSQ
extends AbstractIRODSPackingInstruction {
    private static final String PI_TAG = "generalAdminInp_PI";
    private static final String ARG0 = "arg0";
    private static final String ARG1 = "arg1";
    private static final String ARG2 = "arg2";
    private static final String ARG3 = "arg3";
    private static final String ARG4 = "arg4";
    private static final String ARG5 = "arg5";
    private static final String ARG6 = "arg6";
    private static final String ARG7 = "arg7";
    private static final String ARG8 = "arg8";
    private static final String ARG9 = "arg9";
    private static final String BLANK = "";
    private static final String ADMIN_OBJ = "specificQuery";
    private static final String SQ_ADD = "add";
    private static final String SQ_RM = "rm";
    private String sqlQuery = "";
    private String alias = "";
    private String action;

    public static final GeneralAdminInpForSQ instanceForAddSpecificQuery(SpecificQueryDefinition specificQuery) throws JargonException {
        if (specificQuery == null) {
            throw new IllegalArgumentException("null SpecificQueryDefinition object");
        }
        String query = specificQuery.getSql();
        String alias = specificQuery.getAlias();
        GeneralAdminInpForSQ generalAdminInpForSQ = new GeneralAdminInpForSQ(query, alias, SQ_ADD);
        return generalAdminInpForSQ;
    }

    public static final GeneralAdminInpForSQ instanceForRemoveSpecificQuery(SpecificQueryDefinition specificQuery) throws JargonException {
        if (specificQuery == null) {
            throw new IllegalArgumentException("null SpecificQueryDefinition object");
        }
        return GeneralAdminInpForSQ.instanceForRemoveSpecificQueryByAlias(specificQuery.getAlias());
    }

    public static final GeneralAdminInpForSQ instanceForRemoveSpecificQueryByAlias(String alias) throws JargonException {
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("null or missing alias name");
        }
        GeneralAdminInpForSQ generalAdminInpForSQ = new GeneralAdminInpForSQ(BLANK, alias, SQ_RM);
        return generalAdminInpForSQ;
    }

    public static final GeneralAdminInpForSQ instanceForRemoveAllSpecificQueryBySQL(String query) throws JargonException {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("null or missing SQL query");
        }
        GeneralAdminInpForSQ generalAdminInpForSQ = new GeneralAdminInpForSQ(query, BLANK, SQ_RM);
        return generalAdminInpForSQ;
    }

    private GeneralAdminInpForSQ(String query, String alias, String action) {
        if (action == SQ_ADD) {
            if (query == null || query.isEmpty()) {
                throw new IllegalArgumentException("null or missing SQL statement");
            }
            if (alias == null || alias.isEmpty()) {
                throw new IllegalArgumentException("null or missing alias");
            }
        } else if (action == SQ_RM && (query == null || query.isEmpty()) && (alias == null || alias.isEmpty())) {
            throw new IllegalArgumentException("either sqlQuery or alias is required");
        }
        this.setApiNumber(701);
        this.sqlQuery = query;
        this.alias = alias;
        this.action = action;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        String arg2 = this.getSqlQuery();
        String arg3 = this.getAlias();
        if (this.action.equals(SQ_RM) && arg2.equals(BLANK)) {
            arg2 = arg3;
            arg3 = BLANK;
        }
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(ARG0, this.getAction()), new Tag(ARG1, ADMIN_OBJ), new Tag(ARG2, arg2), new Tag(ARG3, arg3), new Tag(ARG4, BLANK), new Tag(ARG5, BLANK), new Tag(ARG6, BLANK), new Tag(ARG7, BLANK), new Tag(ARG8, BLANK), new Tag(ARG9, BLANK)});
        return message;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

