/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.ArrayList;
import java.util.List;

public enum AuthScheme {
    STANDARD("STANDARD"),
    GSI("GSI"),
    KERBEROS("KERBEROS"),
    PAM("PAM");

    private String textValue;

    private AuthScheme(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public static List<String> getAuthSchemeList() {
        ArrayList<String> authSchemes = new ArrayList<String>();
        for (AuthScheme authScheme : AuthScheme.values()) {
            authSchemes.add(authScheme.textValue);
        }
        return authSchemes;
    }

    public static AuthScheme findTypeByString(String authType) {
        AuthScheme authSchemeValue = null;
        for (AuthScheme authScheme : AuthScheme.values()) {
            if (!authScheme.getTextValue().equals(authType)) continue;
            authSchemeValue = authScheme;
            break;
        }
        if (authSchemeValue == null) {
            authSchemeValue = STANDARD;
        }
        return authSchemeValue;
    }
}

