/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.AbstractConnection;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.AuthenticationFactory;
import org.irods.jargon.core.connection.EnvironmentalInfoAccessor;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSConnectionFactory;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIRODSMidLevelProtocolFactory {
    private final IRODSConnectionFactory irodsConnectionFactory;
    private final AuthenticationFactory authenticationFactory;
    Logger log = LoggerFactory.getLogger(AbstractIRODSMidLevelProtocolFactory.class);

    protected AbstractIRODSMidLevelProtocolFactory(IRODSConnectionFactory irodsConnectionFactory, AuthenticationFactory authenticationFactory) {
        if (irodsConnectionFactory == null) {
            throw new IllegalArgumentException("null irodsConnectionFactory");
        }
        if (authenticationFactory == null) {
            throw new IllegalArgumentException("null authenticationFactory");
        }
        this.irodsConnectionFactory = irodsConnectionFactory;
        this.authenticationFactory = authenticationFactory;
    }

    protected IRODSConnectionFactory getIrodsConnectionFactory() {
        return this.irodsConnectionFactory;
    }

    protected AuthenticationFactory getAuthenticationFactory() {
        return this.authenticationFactory;
    }

    protected AbstractIRODSMidLevelProtocol instance(IRODSSession irodsSession, IRODSAccount irodsAccount, IRODSProtocolManager irodsProtocolManager) throws AuthenticationException, JargonException {
        this.log.info("instance() method...calling connection life cycle");
        this.log.info("create connection....");
        AbstractConnection connection = this.irodsConnectionFactory.instance(irodsAccount, irodsSession, irodsProtocolManager);
        AbstractIRODSMidLevelProtocol protocol = this.createInitialProtocol(connection, irodsProtocolManager);
        try {
            protocol.setIrodsSession(irodsSession);
            this.log.info("...have connection, now authenticate given the auth scheme in the iRODS account...");
            protocol = this.authenticate(protocol, irodsAccount, irodsSession, irodsProtocolManager);
            this.log.info("..authenticated...now decorate and return...");
            return this.decorate(protocol, irodsAccount, irodsSession);
        }
        catch (AuthenticationException e) {
            this.log.warn("auth failure, be sure to abandon agent)", (Throwable)e);
            protocol.disconnectWithForce();
            throw e;
        }
    }

    protected abstract AbstractIRODSMidLevelProtocol createInitialProtocol(AbstractConnection var1, IRODSProtocolManager var2);

    protected AbstractIRODSMidLevelProtocol decorate(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, IRODSAccount irodsAccount, IRODSSession irodsSession) throws JargonException {
        this.log.info("decorate()");
        if (irodsMidLevelProtocol == null) {
            throw new IllegalArgumentException("null irodsMidLevelProtocol");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        if (irodsMidLevelProtocol.getIrodsServerProperties() == null) {
            EnvironmentalInfoAccessor environmentalInfoAccessor = new EnvironmentalInfoAccessor(irodsMidLevelProtocol);
            irodsMidLevelProtocol.setIrodsServerProperties(environmentalInfoAccessor.getIRODSServerProperties());
        }
        this.log.info(irodsMidLevelProtocol.getIrodsServerProperties().toString());
        return irodsMidLevelProtocol;
    }

    protected AbstractIRODSMidLevelProtocol authenticate(AbstractIRODSMidLevelProtocol protocol, IRODSAccount irodsAccount, IRODSSession irodsSession, IRODSProtocolManager irodsProtocolManager) throws AuthenticationException, JargonException {
        this.log.info("authenticate()");
        if (protocol == null) {
            throw new IllegalArgumentException("null connection");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        this.log.info("get auth mechanism");
        AuthMechanism authMechanism = this.getAuthenticationFactory().instanceAuthMechanism(irodsAccount);
        protocol.setIrodsSession(irodsSession);
        this.log.info("authenticate...");
        AbstractIRODSMidLevelProtocol authenticatedProtocol = null;
        try {
            authenticatedProtocol = authMechanism.authenticate(protocol, irodsAccount);
        }
        catch (AuthenticationException e) {
            this.log.error("authentication exception, will close iRODS connection and re-throw", (Throwable)e);
            protocol.disconnectWithForce();
            throw e;
        }
        return authenticatedProtocol;
    }
}

