/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.jnagmp;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;

public final class LibGmp {
    private static final Class SIZE_T_CLASS;
    public static final String __gmp_version;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void loadLibGmp() {
        try {
            File file = Native.extractFromResourcePath((String)"gmp", (ClassLoader)LibGmp.class.getClassLoader());
            LibGmp.load(file.getAbsolutePath());
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        LibGmp.load("gmp");
    }

    private static void load(String name) {
        NativeLibrary library = NativeLibrary.getInstance((String)name, (ClassLoader)LibGmp.class.getClassLoader());
        Native.register(LibGmp.class, (NativeLibrary)library);
        Native.register((Class)SIZE_T_CLASS, (NativeLibrary)library);
    }

    public static void init() {
    }

    public static int readSizeT(Pointer ptr) {
        if (SIZE_T_CLASS == SizeT4.class) {
            int result = ptr.getInt(0L);
            if (!$assertionsDisabled && result < 0) {
                throw new AssertionError();
            }
            return result;
        }
        long result = ptr.getLong(0L);
        if (!$assertionsDisabled && result < 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && result >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        return (int)result;
    }

    public static void __gmpz_import(mpz_t rop, int count, int order, int size, int endian, int nails, Pointer buffer) {
        if (SIZE_T_CLASS == SizeT4.class) {
            SizeT4.__gmpz_import(rop, count, order, size, endian, nails, buffer);
        } else {
            SizeT8.__gmpz_import(rop, count, order, size, endian, nails, buffer);
        }
    }

    public static void __gmpz_export(Pointer rop, Pointer countp, int order, int size, int endian, int nails, mpz_t op) {
        if (SIZE_T_CLASS == SizeT4.class) {
            SizeT4.__gmpz_export(rop, countp, order, size, endian, nails, op);
        } else {
            SizeT8.__gmpz_export(rop, countp, order, size, endian, nails, op);
        }
    }

    public static native void __gmpz_init(mpz_t var0);

    public static native void __gmpz_init2(mpz_t var0, NativeLong var1);

    public static native void __gmpz_clear(mpz_t var0);

    public static native void __gmpz_neg(mpz_t var0, mpz_t var1);

    public static native void __gmpz_powm(mpz_t var0, mpz_t var1, mpz_t var2, mpz_t var3);

    public static native int __gmpz_cmp_si(mpz_t var0, NativeLong var1);

    public static native void __gmpz_powm_sec(mpz_t var0, mpz_t var1, mpz_t var2, mpz_t var3);

    public static native int __gmpz_invert(mpz_t var0, mpz_t var1, mpz_t var2);

    public static native int __gmpz_jacobi(mpz_t var0, mpz_t var1);

    public static native void __gmpz_mul(mpz_t var0, mpz_t var1, mpz_t var2);

    public static native void __gmpz_mod(mpz_t var0, mpz_t var1, mpz_t var2);

    public static native void __gmpz_divexact(mpz_t var0, mpz_t var1, mpz_t var2);

    public static native void __gmpz_gcd(mpz_t var0, mpz_t var1, mpz_t var2);

    private LibGmp() {
    }

    static {
        boolean bl = $assertionsDisabled = !LibGmp.class.desiredAssertionStatus();
        if (Native.SIZE_T_SIZE == 4) {
            SIZE_T_CLASS = SizeT4.class;
        } else if (Native.SIZE_T_SIZE == 8) {
            SIZE_T_CLASS = SizeT8.class;
        } else {
            throw new AssertionError((Object)("Unexpected Native.SIZE_T_SIZE: " + Native.SIZE_T_SIZE));
        }
        LibGmp.loadLibGmp();
        __gmp_version = NativeLibrary.getProcess().getGlobalVariableAddress("__gmp_version").getPointer(0L).getString(0L);
    }

    static class SizeT8 {
        SizeT8() {
        }

        static native void __gmpz_import(mpz_t var0, long var1, int var3, int var4, int var5, long var6, Pointer var8);

        static native Pointer __gmpz_export(Pointer var0, Pointer var1, int var2, long var3, int var5, long var6, mpz_t var8);
    }

    static class SizeT4 {
        SizeT4() {
        }

        static native void __gmpz_import(mpz_t var0, int var1, int var2, int var3, int var4, int var5, Pointer var6);

        static native Pointer __gmpz_export(Pointer var0, Pointer var1, int var2, int var3, int var4, int var5, mpz_t var6);
    }

    public static class mpz_t
    extends Pointer {
        public static final int SIZE = 16;

        public mpz_t(long peer) {
            super(peer);
        }

        public mpz_t(Pointer from) {
            this(Pointer.nativeValue((Pointer)from));
        }
    }
}

