/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class EncryptingWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final Cryptor cryptor;
    private final FileHeader header;
    private final ByteBuffer cleartextBuffer;
    private boolean firstWrite = true;
    private long chunkNumber = 0L;

    public EncryptingWritableByteChannel(WritableByteChannel destination, Cryptor cryptor) {
        this.delegate = destination;
        this.cryptor = cryptor;
        this.header = cryptor.fileHeaderCryptor().create();
        this.cleartextBuffer = ByteBuffer.allocate(cryptor.fileContentCryptor().cleartextChunkSize());
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public synchronized void close() throws IOException {
        this.writeHeaderOnFirstWrite();
        this.encryptAndFlushBuffer();
        this.delegate.close();
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        this.writeHeaderOnFirstWrite();
        int result = 0;
        while (src.hasRemaining()) {
            result += ByteBuffers.copy(src, this.cleartextBuffer);
            if (this.cleartextBuffer.hasRemaining()) continue;
            this.encryptAndFlushBuffer();
        }
        return result;
    }

    private void writeHeaderOnFirstWrite() throws IOException {
        if (this.firstWrite) {
            this.delegate.write(this.cryptor.fileHeaderCryptor().encryptHeader(this.header));
        }
        this.firstWrite = false;
    }

    private void encryptAndFlushBuffer() throws IOException {
        this.cleartextBuffer.flip();
        if (this.cleartextBuffer.hasRemaining()) {
            ByteBuffer ciphertextBuffer = this.cryptor.fileContentCryptor().encryptChunk(this.cleartextBuffer, this.chunkNumber++, this.header);
            this.delegate.write(ciphertextBuffer);
        }
        this.cleartextBuffer.clear();
    }
}

