/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReseedingSecureRandom
extends SecureRandom {
    private static final Logger LOG = LoggerFactory.getLogger(ReseedingSecureRandom.class);
    private static final Provider PROVIDER = new ReseedingSecureRandomProvider();

    public ReseedingSecureRandom(SecureRandom seeder, SecureRandom csprng, long reseedAfter, int seedLength) {
        super(new ReseedingSecureRandomSpi(seeder, csprng, reseedAfter, seedLength), PROVIDER);
    }

    private static class ReseedingSecureRandomSpi
    extends SecureRandomSpi {
        private final SecureRandom seeder;
        private final SecureRandom csprng;
        private final long reseedAfter;
        private final int seedLength;
        private long counter;

        public ReseedingSecureRandomSpi(SecureRandom seeder, SecureRandom csprng, long reseedAfter, int seedLength) {
            this.seeder = seeder;
            this.csprng = csprng;
            this.reseedAfter = reseedAfter;
            this.seedLength = seedLength;
            this.counter = reseedAfter;
        }

        @Override
        protected void engineSetSeed(byte[] seed) {
            this.csprng.setSeed(seed);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            if (this.counter + (long)bytes.length > this.reseedAfter) {
                this.reseed();
            }
            this.counter += (long)bytes.length;
            this.csprng.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            try {
                LOG.info("Seeding CSPRNG with {} bytes...", (Object)numBytes);
                byte[] byArray = this.seeder.generateSeed(numBytes);
                return byArray;
            }
            finally {
                LOG.info("Seeded CSPRNG.");
            }
        }

        private void reseed() {
            this.engineSetSeed(this.engineGenerateSeed(this.seedLength));
            this.counter = 0L;
        }
    }

    private static class ReseedingSecureRandomProvider
    extends Provider {
        protected ReseedingSecureRandomProvider() {
            super("ReseedingSecureRandomProvider", 1.0, "Provides ReseedingSecureRandom");
        }
    }
}

