/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import javax.swing.UIManager;

class ColorModel {
    private final String prefix;
    private final String[] labels;

    ColorModel(String string, String ... stringArray) {
        this.prefix = "ColorChooser." + string;
        this.labels = stringArray;
    }

    ColorModel() {
        this("rgb", "Red", "Green", "Blue", "Alpha");
    }

    void setColor(int n, float[] fArray) {
        fArray[0] = ColorModel.normalize(n >> 16);
        fArray[1] = ColorModel.normalize(n >> 8);
        fArray[2] = ColorModel.normalize(n);
        fArray[3] = ColorModel.normalize(n >> 24);
    }

    int getColor(float[] fArray) {
        return ColorModel.to8bit(fArray[2]) | ColorModel.to8bit(fArray[1]) << 8 | ColorModel.to8bit(fArray[0]) << 16 | ColorModel.to8bit(fArray[3]) << 24;
    }

    int getCount() {
        return this.labels.length;
    }

    int getMinimum(int n) {
        return 0;
    }

    int getMaximum(int n) {
        return 255;
    }

    float getDefault(int n) {
        return 0.0f;
    }

    final String getLabel(Component component, int n) {
        return this.getText(component, this.labels[n]);
    }

    private static float normalize(int n) {
        return (float)(n & 0xFF) / 255.0f;
    }

    private static int to8bit(float f) {
        return (int)(255.0f * f);
    }

    final String getText(Component component, String string) {
        return UIManager.getString((Object)(this.prefix + string + "Text"), component.getLocale());
    }

    final int getInteger(Component component, String string) {
        Object object = UIManager.get(this.prefix + string, component.getLocale());
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

