/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tracing;

import com.sun.tracing.Provider;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import sun.security.action.GetPropertyAction;
import sun.tracing.MultiplexProviderFactory;
import sun.tracing.NullProviderFactory;
import sun.tracing.PrintStreamProviderFactory;
import sun.tracing.dtrace.DTraceProviderFactory;

public abstract class ProviderFactory {
    protected ProviderFactory() {
    }

    public abstract <T extends Provider> T createProvider(Class<T> var1);

    public static ProviderFactory getDefaultFactory() {
        HashSet<ProviderFactory> hashSet = new HashSet<ProviderFactory>();
        String string = AccessController.doPrivileged(new GetPropertyAction("com.sun.tracing.dtrace"));
        if ((string == null || !string.equals("disable")) && DTraceProviderFactory.isSupported()) {
            hashSet.add(new DTraceProviderFactory());
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.tracing.stream"))) != null) {
            for (String string2 : string.split(",")) {
                PrintStream printStream = ProviderFactory.getPrintStreamFromSpec(string2);
                if (printStream == null) continue;
                hashSet.add(new PrintStreamProviderFactory(printStream));
            }
        }
        if (hashSet.size() == 0) {
            return new NullProviderFactory();
        }
        if (hashSet.size() == 1) {
            return hashSet.toArray(new ProviderFactory[1])[0];
        }
        return new MultiplexProviderFactory(hashSet);
    }

    private static PrintStream getPrintStreamFromSpec(final String string) {
        try {
            final int n = string.lastIndexOf(46);
            final Class<?> clazz = Class.forName(string.substring(0, n));
            Field field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws NoSuchFieldException {
                    return clazz.getField(string.substring(n + 1));
                }
            });
            return (PrintStream)field.get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new AssertionError((Object)privilegedActionException);
        }
    }
}

