/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import java.util.List;

public class DriveDeleteFeature
implements Delete {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveDeleteFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (file.getType().contains(AbstractPath.Type.placeholder)) continue;
            callback.delete(file);
            try {
                if (DriveHomeFinderService.TEAM_DRIVES_NAME.equals((Object)file.getParent())) {
                    ((Drive)this.session.getClient()).teamdrives().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).execute();
                    continue;
                }
                ((Drive)this.session.getClient()).files().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return true;
    }
}

