/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MD5ChecksumCompute;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3TouchFeature;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3MultipartWriteFeature
implements MultipartWrite<List<MultipartPart>> {
    private static final Logger log = Logger.getLogger(S3MultipartWriteFeature.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final Find finder;
    private final AttributesFinder attributes;

    public S3MultipartWriteFeature(S3Session session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public S3MultipartWriteFeature(S3Session session, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<List<MultipartPart>> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        MultipartUpload multipart;
        S3Object object = new S3WriteFeature(this.session, new S3DisabledMultipartService()).getDetails(file, status);
        try {
            multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(this.containerService.getContainer(file).getName(), object);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Upload {0} failed", e, file);
        }
        final MultipartOutputStream proxy = new MultipartOutputStream(multipart, file, status);
        return new HttpResponseOutputStream<List<MultipartPart>>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(this.preferences.getInteger("s3.upload.multipart.partsize.minimum")))){

            public List<MultipartPart> getStatus() throws BackgroundException {
                return proxy.getCompleted();
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final List<MultipartPart> completed = new ArrayList<MultipartPart>();
        private final MultipartUpload multipart;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private int partNumber;

        public MultipartOutputStream(MultipartUpload multipart, Path file, TransferStatus status) {
            this.multipart = multipart;
            this.file = file;
            this.overall = status;
        }

        public List<MultipartPart> getCompleted() {
            return this.completed;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                this.completed.add((MultipartPart)new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<MultipartPart>(){

                    public MultipartPart call() throws BackgroundException {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("uploadId", MultipartOutputStream.this.multipart.getUploadId());
                        parameters.put("partNumber", String.valueOf(++MultipartOutputStream.this.partNumber));
                        TransferStatus status = new TransferStatus().withParameters(parameters).length((long)len);
                        switch (S3MultipartWriteFeature.this.session.getSignatureVersion()) {
                            case AWS4HMACSHA256: {
                                status.setChecksum(ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256).compute((InputStream)new ByteArrayInputStream(content, off, len), status));
                            }
                        }
                        status.setSegment(true);
                        S3Object part = new S3WriteFeature(S3MultipartWriteFeature.this.session, new S3DisabledMultipartService()).getDetails(MultipartOutputStream.this.file, status);
                        try {
                            ((RequestEntityRestStorageService)((Object)S3MultipartWriteFeature.this.session.getClient())).putObjectWithRequestEntityImpl(S3MultipartWriteFeature.this.containerService.getContainer(MultipartOutputStream.this.file).getName(), (StorageObject)part, (HttpEntity)new ByteArrayEntity(content, off, len), parameters);
                        }
                        catch (ServiceException e) {
                            throw new S3ExceptionMappingService().map("Upload {0} failed", e, MultipartOutputStream.this.file);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Saved object %s with checksum %s", MultipartOutputStream.this.file, part.getETag()));
                        }
                        return new MultipartPart(Integer.valueOf(MultipartOutputStream.this.partNumber), null == part.getLastModifiedDate() ? new Date(System.currentTimeMillis()) : part.getLastModifiedDate(), null == part.getETag() ? "" : part.getETag(), Long.valueOf(part.getContentLength()));
                    }
                }, this.overall).call());
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (this.completed.isEmpty()) {
                    log.warn((Object)String.format("Abort multipart upload %s with no completed parts", this.multipart));
                    ((RequestEntityRestStorageService)((Object)S3MultipartWriteFeature.this.session.getClient())).multipartAbortUpload(this.multipart);
                    new S3TouchFeature(S3MultipartWriteFeature.this.session).touch(this.file, new TransferStatus());
                } else {
                    MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)S3MultipartWriteFeature.this.session.getClient())).multipartCompleteUpload(this.multipart, this.completed);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Completed multipart upload for %s with checksum %s", complete.getObjectKey(), complete.getEtag()));
                    }
                    if (this.file.getType().contains(AbstractPath.Type.encrypted)) {
                        log.warn((Object)String.format("Skip checksum verification for %s with client side encryption enabled", this.file));
                    } else {
                        String reference;
                        StringBuilder concat = new StringBuilder();
                        for (MultipartPart part : this.completed) {
                            concat.append(part.getEtag());
                        }
                        String expected = String.format("%s-%d", new MD5ChecksumCompute().compute(concat.toString(), new TransferStatus()), this.completed.size());
                        if (!expected.equals(reference = complete.getEtag().startsWith("\"") && complete.getEtag().endsWith("\"") ? complete.getEtag().substring(1, complete.getEtag().length() - 1) : complete.getEtag())) {
                            if (S3MultipartWriteFeature.this.session.getHost().getHostname().endsWith(S3MultipartWriteFeature.this.preferences.getProperty("s3.hostname.default"))) {
                                throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), this.file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", expected, reference));
                            }
                            log.warn((Object)String.format("Mismatch between MD5 hash %s of uploaded data and ETag %s returned by the server", expected, reference));
                        }
                    }
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            catch (ServiceException e) {
                throw new IOException(e.getErrorMessage(), new S3ExceptionMappingService().map(e));
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("multipart=").append(this.multipart);
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }
    }
}

