/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;

public class DropboxDirectoryFeature
implements Directory<String> {
    private final DropboxSession session;

    public DropboxDirectoryFeature(DropboxSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            FolderMetadata metadata = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).createFolder(folder.getAbsolute());
            return new Path(folder.getParent(), folder.getName(), folder.getType(), new DropboxAttributesFinderFeature(this.session).toAttributes((Metadata)metadata));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public DropboxDirectoryFeature withWriter(Write<String> writer) {
        return this;
    }
}

