/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.ftp.DataConnectionAction;
import ch.cyberduck.core.ftp.DataConnectionActionExecutor;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(FTPReadFeature.class);
    private final FTPSession session;

    public FTPReadFeature(FTPSession session) {
        this.session = session;
    }

    public InputStream read(final Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (!((FTPClient)((Object)this.session.getClient())).setFileType(2)) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            if (status.isAppend()) {
                ((FTPClient)((Object)this.session.getClient())).setRestartOffset(status.getOffset());
            }
            InputStream in = new DataConnectionActionExecutor(this.session).data(new DataConnectionAction<InputStream>(){

                @Override
                public InputStream execute() throws BackgroundException {
                    try {
                        return ((FTPClient)((Object)FTPReadFeature.this.session.getClient())).retrieveFileStream(file.getAbsolute());
                    }
                    catch (IOException e) {
                        throw new FTPExceptionMappingService().map(e);
                    }
                }
            }, (ProgressListener)new DisabledProgressListener());
            return new ReadReplyInputStream(in, status);
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        try {
            return ((FTPClient)((Object)this.session.getClient())).hasFeature("REST", "STREAM");
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    private final class ReadReplyInputStream
    extends ProxyInputStream {
        private final AtomicBoolean close;
        private final TransferStatus status;

        public ReadReplyInputStream(InputStream proxy, TransferStatus status) {
            super(proxy);
            this.status = status;
            this.close = new AtomicBoolean();
        }

        public void close() throws IOException {
            block6: {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
                    return;
                }
                try {
                    int reply;
                    super.close();
                    if (!FTPReadFeature.this.session.isConnected() || FTPReply.isPositiveCompletion((int)(reply = ((FTPClient)((Object)FTPReadFeature.this.session.getClient())).getReply()))) break block6;
                    String text = ((FTPClient)((Object)FTPReadFeature.this.session.getClient())).getReplyString();
                    if (this.status.isSegment()) {
                        log.warn((Object)String.format("Ignore unexpected reply %s when completing file segment %s", text, this.status));
                        break block6;
                    }
                    if (!this.status.isComplete()) {
                        log.warn((Object)String.format("Ignore unexpected reply %s with incomplete transfer status %s", text, this.status));
                        break block6;
                    }
                    log.warn((Object)String.format("Unexpected reply %s when completing file download with status %s", text, this.status));
                    throw new FTPException(((FTPClient)((Object)FTPReadFeature.this.session.getClient())).getReplyCode(), text);
                }
                finally {
                    this.close.set(true);
                }
            }
        }
    }
}

