/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.collect.ImmutableMap;
import com.spectralogic.ds3client.commands.PutObjectRequest;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.MetadataAccess;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutJobTransferMethod
implements TransferMethod {
    private static final Logger LOG = LoggerFactory.getLogger(PutJobTransferMethod.class);
    private final ChannelStrategy channelStrategy;
    private final String bucketName;
    private final String jobId;
    private final EventDispatcher eventDispatcher;
    private final ChecksumFunction checksumFunction;
    private final ChecksumType.Type checksumType;
    private final MetadataAccess metadataAccess;

    public PutJobTransferMethod(ChannelStrategy channelStrategy, String bucketName, String jobId, EventDispatcher eventDispatcher, ChecksumFunction checksumFunction, ChecksumType.Type checksumType, MetadataAccess metadataAccess) {
        this.channelStrategy = channelStrategy;
        this.bucketName = bucketName;
        this.jobId = jobId;
        this.eventDispatcher = eventDispatcher;
        this.checksumFunction = checksumFunction;
        this.checksumType = checksumType;
        this.metadataAccess = metadataAccess;
    }

    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        BulkObject blob = jobPart.getBlob();
        SeekableByteChannel seekableByteChannel = this.channelStrategy.acquireChannelForBlob(blob);
        jobPart.getClient().putObject(this.makePutObjectRequest(seekableByteChannel, jobPart));
        this.channelStrategy.releaseChannelForBlob(seekableByteChannel, blob);
        this.eventDispatcher.emitBlobTransferredEvent(blob);
        this.eventDispatcher.emitDataTransferredEvent(blob);
    }

    private PutObjectRequest makePutObjectRequest(SeekableByteChannel seekableByteChannel, JobPart jobPart) {
        BulkObject blob = jobPart.getBlob();
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, blob.getName(), seekableByteChannel, this.jobId, blob.getOffset(), blob.getLength());
        this.addCheckSum(blob, putObjectRequest);
        this.addMetadata(blob, putObjectRequest);
        return putObjectRequest;
    }

    private void addCheckSum(BulkObject blob, PutObjectRequest putObjectRequest) {
        if (this.checksumFunction != null) {
            try {
                SeekableByteChannel byteChannel = this.channelStrategy.acquireChannelForBlob(blob);
                String checksum = this.checksumFunction.compute(blob, byteChannel);
                if (checksum != null) {
                    putObjectRequest.withChecksum(ChecksumType.value(checksum), this.checksumType);
                    this.eventDispatcher.emitChecksumEvent(blob, this.checksumType, checksum);
                }
            }
            catch (IOException e) {
                LOG.info("Failure creating channel to calculate checksum.", (Throwable)e);
            }
        }
    }

    private void addMetadata(BulkObject blob, PutObjectRequest putObjectRequest) {
        Map metadata;
        if (this.metadataAccess != null && !Guard.isMapNullOrEmpty((Map)(metadata = this.metadataAccess.getMetadataValue(blob.getName())))) {
            ImmutableMap immutableMetadata = ImmutableMap.copyOf((Map)metadata);
            for (Map.Entry value : immutableMetadata.entrySet()) {
                putObjectRequest.withMetaData((String)value.getKey(), (String)value.getValue());
            }
        }
    }
}

