/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.FailureEventListener;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.WaitingForChunksListener;
import com.spectralogic.ds3client.helpers.events.EventRunner;
import com.spectralogic.ds3client.helpers.events.FailureEvent;
import com.spectralogic.ds3client.helpers.events.MetadataEvent;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.BlobTransferredEventObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.ChecksumEvent;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.ChecksumObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.DataTransferredObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.FailureEventObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.MetaDataReceivedObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.ObjectCompletedObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.Observer;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.WaitingForChunksObserver;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.networking.Metadata;
import java.util.Map;
import java.util.Set;

public class EventDispatcherImpl
implements EventDispatcher {
    private final EventRunner eventRunner;
    private final Set<DataTransferredObserver> dataTransferredObservers = Sets.newIdentityHashSet();
    private final Set<ObjectCompletedObserver> objectCompletedObservers = Sets.newIdentityHashSet();
    private final Set<ChecksumObserver> checksumObservers = Sets.newIdentityHashSet();
    private final Set<WaitingForChunksObserver> waitingForChunksObservers = Sets.newIdentityHashSet();
    private final Set<FailureEventObserver> failureEventObservers = Sets.newIdentityHashSet();
    private final Set<MetaDataReceivedObserver> metaDataReceivedObservers = Sets.newConcurrentHashSet();
    private final Set<BlobTransferredEventObserver> blobTransferredEventObservers = Sets.newIdentityHashSet();
    private final Map<DataTransferredListener, DataTransferredObserver> dataTransferredListeners = Maps.newConcurrentMap();
    private final Map<ObjectCompletedListener, ObjectCompletedObserver> objectCompletedListeners = Maps.newIdentityHashMap();
    private final Map<MetadataReceivedListener, MetaDataReceivedObserver> metadataReceivedListeners = Maps.newIdentityHashMap();
    private final Map<ChecksumListener, ChecksumObserver> checksumListeners = Maps.newIdentityHashMap();
    private final Map<WaitingForChunksListener, WaitingForChunksObserver> waitingForChunksListeners = Maps.newIdentityHashMap();
    private final Map<FailureEventListener, FailureEventObserver> failureEventListeners = Maps.newIdentityHashMap();

    public EventDispatcherImpl(EventRunner eventRunner) {
        Preconditions.checkNotNull((Object)eventRunner, (Object)"eventRunner must not be null.");
        this.eventRunner = eventRunner;
    }

    @Override
    public DataTransferredObserver attachDataTransferredObserver(DataTransferredObserver dataTransferredObserver) {
        this.dataTransferredObservers.add(dataTransferredObserver);
        return dataTransferredObserver;
    }

    @Override
    public void removeDataTransferredObserver(DataTransferredObserver dataTransferredObserver) {
        this.dataTransferredObservers.remove(dataTransferredObserver);
    }

    @Override
    public ObjectCompletedObserver attachObjectCompletedObserver(ObjectCompletedObserver objectCompletedObserver) {
        this.objectCompletedObservers.add(objectCompletedObserver);
        return objectCompletedObserver;
    }

    @Override
    public void removeObjectCompletedObserver(ObjectCompletedObserver objectCompletedObserver) {
        this.objectCompletedObservers.remove(objectCompletedObserver);
    }

    @Override
    public ChecksumObserver attachChecksumObserver(ChecksumObserver checksumObserver) {
        this.checksumObservers.add(checksumObserver);
        return checksumObserver;
    }

    @Override
    public void removeChecksumObserver(ChecksumObserver checksumObserver) {
        this.checksumObservers.remove(checksumObserver);
    }

    @Override
    public WaitingForChunksObserver attachWaitingForChunksObserver(WaitingForChunksObserver waitingForChunksObserver) {
        this.waitingForChunksObservers.add(waitingForChunksObserver);
        return waitingForChunksObserver;
    }

    @Override
    public void removeWaitingForChunksObserver(WaitingForChunksObserver waitingForChunksObserver) {
        this.waitingForChunksObservers.remove(waitingForChunksObserver);
    }

    @Override
    public FailureEventObserver attachFailureEventObserver(FailureEventObserver failureEventObserver) {
        this.failureEventObservers.add(failureEventObserver);
        return failureEventObserver;
    }

    @Override
    public void removeFailureEventObserver(FailureEventObserver failureEventObserver) {
        this.failureEventObservers.remove(failureEventObserver);
    }

    @Override
    public MetaDataReceivedObserver attachMetadataReceivedEventObserver(MetaDataReceivedObserver metaDataReceivedObserver) {
        this.metaDataReceivedObservers.add(metaDataReceivedObserver);
        return metaDataReceivedObserver;
    }

    @Override
    public void removeMetadataReceivedEventObserver(MetaDataReceivedObserver metaDataReceivedObserver) {
        this.metaDataReceivedObservers.remove(metaDataReceivedObserver);
    }

    @Override
    public BlobTransferredEventObserver attachBlobTransferredEventObserver(BlobTransferredEventObserver blobTransferredEventObserver) {
        this.blobTransferredEventObservers.add(blobTransferredEventObserver);
        return blobTransferredEventObserver;
    }

    @Override
    public void removeBlobTransferredEventObserver(BlobTransferredEventObserver blobTransferredEventObserver) {
        this.blobTransferredEventObservers.remove(blobTransferredEventObserver);
    }

    @Override
    public void attachDataTransferredListener(DataTransferredListener listener) {
        DataTransferredObserver dataTransferredObserver = this.dataTransferredListeners.get(listener);
        if (dataTransferredObserver == null) {
            dataTransferredObserver = this.attachDataTransferredObserver(new DataTransferredObserver(listener));
            this.dataTransferredListeners.put(listener, dataTransferredObserver);
        }
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        DataTransferredObserver dataTransferredObserver = this.dataTransferredListeners.get(listener);
        if (dataTransferredObserver != null) {
            this.removeDataTransferredObserver(dataTransferredObserver);
            this.dataTransferredListeners.remove(listener);
        }
    }

    @Override
    public void attachObjectCompletedListener(ObjectCompletedListener listener) {
        ObjectCompletedObserver objectCompletedObserver = this.objectCompletedListeners.get(listener);
        if (objectCompletedObserver == null) {
            objectCompletedObserver = this.attachObjectCompletedObserver(new ObjectCompletedObserver(listener));
            this.objectCompletedListeners.put(listener, objectCompletedObserver);
        }
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        ObjectCompletedObserver objectCompletedObserver = this.objectCompletedListeners.get(listener);
        if (objectCompletedObserver != null) {
            this.removeObjectCompletedObserver(objectCompletedObserver);
            this.objectCompletedListeners.remove(listener);
        }
    }

    @Override
    public void attachMetadataReceivedListener(MetadataReceivedListener listener) {
        MetaDataReceivedObserver metaDataReceivedObserver = this.metadataReceivedListeners.get(listener);
        if (metaDataReceivedObserver == null) {
            metaDataReceivedObserver = this.attachMetadataReceivedEventObserver(new MetaDataReceivedObserver(listener));
            this.metadataReceivedListeners.put(listener, metaDataReceivedObserver);
        }
    }

    @Override
    public void removeMetadataReceivedListener(MetadataReceivedListener listener) {
        MetaDataReceivedObserver metaDataReceivedObserver = this.metadataReceivedListeners.get(listener);
        if (metaDataReceivedObserver != null) {
            this.removeMetadataReceivedEventObserver(metaDataReceivedObserver);
            this.metadataReceivedListeners.remove(listener);
        }
    }

    @Override
    public void attachChecksumListener(ChecksumListener listener) {
        ChecksumObserver checksumObserver = this.checksumListeners.get(listener);
        if (checksumObserver == null) {
            checksumObserver = this.attachChecksumObserver(new ChecksumObserver(listener));
            this.checksumListeners.put(listener, checksumObserver);
        }
    }

    @Override
    public void removeChecksumListener(ChecksumListener listener) {
        ChecksumObserver checksumObserver = this.checksumListeners.get(listener);
        if (checksumObserver != null) {
            this.removeChecksumObserver(checksumObserver);
            this.checksumListeners.remove(listener);
        }
    }

    @Override
    public void attachWaitingForChunksListener(WaitingForChunksListener listener) {
        WaitingForChunksObserver waitingForChunksObserver = this.waitingForChunksListeners.get(listener);
        if (waitingForChunksObserver == null) {
            waitingForChunksObserver = this.attachWaitingForChunksObserver(new WaitingForChunksObserver(listener));
            this.waitingForChunksListeners.put(listener, waitingForChunksObserver);
        }
    }

    @Override
    public void removeWaitingForChunksListener(WaitingForChunksListener listener) {
        WaitingForChunksObserver waitingForChunksObserver = this.waitingForChunksListeners.get(listener);
        if (waitingForChunksObserver != null) {
            this.removeWaitingForChunksObserver(waitingForChunksObserver);
            this.waitingForChunksListeners.remove(listener);
        }
    }

    @Override
    public void attachFailureEventListener(FailureEventListener listener) {
        FailureEventObserver failureEventObserver = this.failureEventListeners.get(listener);
        if (failureEventObserver == null) {
            failureEventObserver = this.attachFailureEventObserver(new FailureEventObserver(listener));
            this.failureEventListeners.put(listener, failureEventObserver);
        }
    }

    @Override
    public void removeFailureEventListener(FailureEventListener listener) {
        FailureEventObserver failureEventObserver = this.failureEventListeners.get(listener);
        if (failureEventObserver != null) {
            this.removeFailureEventObserver(failureEventObserver);
            this.failureEventListeners.remove(listener);
        }
    }

    @Override
    public void emitFailureEvent(FailureEvent failureEvent) {
        this.emitEvents(this.failureEventObservers, failureEvent);
    }

    private <T> void emitEvents(Set eventObservers, final T eventData) {
        for (final Object eventObserver : eventObservers) {
            this.eventRunner.emitEvent(new Runnable(){

                @Override
                public void run() {
                    ((Observer)eventObserver).update(eventData);
                }
            });
        }
    }

    @Override
    public void emitWaitingForChunksEvents(int secondsToDelay) {
        this.emitEvents(this.waitingForChunksObservers, secondsToDelay);
    }

    @Override
    public void emitChecksumEvent(BulkObject blob, ChecksumType.Type type, String checksum) {
        this.emitEvents(this.checksumObservers, new ChecksumEvent(blob, type, checksum));
    }

    @Override
    public void emitDataTransferredEvent(BulkObject blob) {
        this.emitEvents(this.dataTransferredObservers, blob.getLength());
    }

    @Override
    public void emitObjectCompletedEvent(BulkObject blob) {
        this.emitObjectCompletedEvent(blob.getName());
    }

    @Override
    public void emitObjectCompletedEvent(String blobName) {
        this.emitEvents(this.objectCompletedObservers, blobName);
    }

    @Override
    public void emitMetaDataReceivedEvent(String objectName, Metadata metadata) {
        this.emitEvents(this.metaDataReceivedObservers, new MetadataEvent(objectName, metadata));
    }

    @Override
    public void emitBlobTransferredEvent(BulkObject blob) {
        this.emitEvents(this.blobTransferredEventObservers, blob);
    }

    @Override
    public void emitContentLengthMismatchFailureEvent(BulkObject ds3Object, String endpoint, Throwable t) {
        FailureEvent failureEvent = FailureEvent.builder().doingWhat(FailureEvent.FailureActivity.GettingObject).usingSystemWithEndpoint(endpoint).withCausalException(t).withObjectNamed(ds3Object.getName()).build();
        this.emitFailureEvent(failureEvent);
    }
}

