/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

public class VerifyBulkJobSpectraS3Request
extends AbstractRequest {
    private final String bucketName;
    private final List<Ds3Object> objects;
    private boolean aggregating;
    private String name;
    private Priority priority;
    private long size = 0L;

    public VerifyBulkJobSpectraS3Request(String bucketName, List<Ds3Object> objects) {
        this.bucketName = bucketName;
        this.objects = objects;
        this.getQueryParams().put("operation", "start_bulk_verify");
    }

    public VerifyBulkJobSpectraS3Request withAggregating(boolean aggregating) {
        this.aggregating = aggregating;
        this.updateQueryParam("aggregating", aggregating);
        return this;
    }

    public VerifyBulkJobSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public VerifyBulkJobSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    @Override
    public InputStream getStream() {
        if (Guard.isNullOrEmpty(this.objects)) {
            return null;
        }
        Ds3ObjectList objects = new Ds3ObjectList();
        objects.setObjects(this.objects);
        String xmlOutput = XmlOutput.toXml(objects, false);
        byte[] stringBytes = xmlOutput.getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket/" + this.bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<Ds3Object> getObjects() {
        return this.objects;
    }

    public boolean getAggregating() {
        return this.aggregating;
    }

    public String getName() {
        return this.name;
    }

    public Priority getPriority() {
        return this.priority;
    }
}

